"use strict";
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
module.exports = {
    "CodeDeploy ECS DeploymentGroup": {
        'imported with fromEcsDeploymentGroupAttributes': {
            'defaults the Deployment Config to AllAtOnce'(test) {
                const stack = new cdk.Stack();
                const ecsApp = codedeploy.EcsApplication.fromEcsApplicationName(stack, 'EA', 'EcsApplication');
                const importedGroup = codedeploy.EcsDeploymentGroup.fromEcsDeploymentGroupAttributes(stack, 'EDG', {
                    application: ecsApp,
                    deploymentGroupName: 'EcsDeploymentGroup',
                });
                test.equal(importedGroup.deploymentConfig, codedeploy.EcsDeploymentConfig.ALL_AT_ONCE);
                test.done();
            },
        },
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5kZXBsb3ltZW50LWdyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidGVzdC5kZXBsb3ltZW50LWdyb3VwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxxQ0FBcUM7QUFFckMsd0NBQXdDO0FBRXhDLGlCQUFTO0lBQ1AsZ0NBQWdDLEVBQUU7UUFDaEMsZ0RBQWdELEVBQUU7WUFDaEQsNkNBQTZDLENBQUMsSUFBVTtnQkFDdEQsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBRTlCLE1BQU0sTUFBTSxHQUFHLFVBQVUsQ0FBQyxjQUFjLENBQUMsc0JBQXNCLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO2dCQUMvRixNQUFNLGFBQWEsR0FBRyxVQUFVLENBQUMsa0JBQWtCLENBQUMsZ0NBQWdDLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRTtvQkFDakcsV0FBVyxFQUFFLE1BQU07b0JBQ25CLG1CQUFtQixFQUFFLG9CQUFvQjtpQkFDMUMsQ0FBQyxDQUFDO2dCQUVILElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxXQUFXLENBQUMsQ0FBQztnQkFFdkYsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ2QsQ0FBQztTQUNGO0tBQ0Y7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgVGVzdCB9IGZyb20gJ25vZGV1bml0JztcbmltcG9ydCAqIGFzIGNvZGVkZXBsb3kgZnJvbSAnLi4vLi4vbGliJztcblxuZXhwb3J0ID0ge1xuICBcIkNvZGVEZXBsb3kgRUNTIERlcGxveW1lbnRHcm91cFwiOiB7XG4gICAgJ2ltcG9ydGVkIHdpdGggZnJvbUVjc0RlcGxveW1lbnRHcm91cEF0dHJpYnV0ZXMnOiB7XG4gICAgICAnZGVmYXVsdHMgdGhlIERlcGxveW1lbnQgQ29uZmlnIHRvIEFsbEF0T25jZScodGVzdDogVGVzdCkge1xuICAgICAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcblxuICAgICAgICBjb25zdCBlY3NBcHAgPSBjb2RlZGVwbG95LkVjc0FwcGxpY2F0aW9uLmZyb21FY3NBcHBsaWNhdGlvbk5hbWUoc3RhY2ssICdFQScsICdFY3NBcHBsaWNhdGlvbicpO1xuICAgICAgICBjb25zdCBpbXBvcnRlZEdyb3VwID0gY29kZWRlcGxveS5FY3NEZXBsb3ltZW50R3JvdXAuZnJvbUVjc0RlcGxveW1lbnRHcm91cEF0dHJpYnV0ZXMoc3RhY2ssICdFREcnLCB7XG4gICAgICAgICAgYXBwbGljYXRpb246IGVjc0FwcCxcbiAgICAgICAgICBkZXBsb3ltZW50R3JvdXBOYW1lOiAnRWNzRGVwbG95bWVudEdyb3VwJyxcbiAgICAgICAgfSk7XG5cbiAgICAgICAgdGVzdC5lcXVhbChpbXBvcnRlZEdyb3VwLmRlcGxveW1lbnRDb25maWcsIGNvZGVkZXBsb3kuRWNzRGVwbG95bWVudENvbmZpZy5BTExfQVRfT05DRSk7XG5cbiAgICAgICAgdGVzdC5kb25lKCk7XG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG59O1xuIl19