"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
function arnForApplication(applicationName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:application:${applicationName}`;
}
exports.arnForApplication = arnForApplication;
function arnForDeploymentGroup(applicationName, deploymentGroupName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
}
exports.arnForDeploymentGroup = arnForDeploymentGroup;
function arnForDeploymentConfig(name) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentconfig:${name}`;
}
exports.arnForDeploymentConfig = arnForDeploymentConfig;
function renderAlarmConfiguration(alarms, ignorePollAlarmFailure) {
    return alarms.length === 0
        ? undefined
        : {
            alarms: alarms.map(a => ({ name: a.alarmName })),
            enabled: true,
            ignorePollAlarmFailure,
        };
}
exports.renderAlarmConfiguration = renderAlarmConfiguration;
var AutoRollbackEvent;
(function (AutoRollbackEvent) {
    AutoRollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(AutoRollbackEvent || (AutoRollbackEvent = {}));
function renderAutoRollbackConfiguration(alarms, autoRollbackConfig = {}) {
    const events = new Array();
    // we roll back failed deployments by default
    if (autoRollbackConfig.failedDeployment !== false) {
        events.push(AutoRollbackEvent.DEPLOYMENT_FAILURE);
    }
    // we _do not_ roll back stopped deployments by default
    if (autoRollbackConfig.stoppedDeployment === true) {
        events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST);
    }
    // we _do not_ roll back alarm-triggering deployments by default
    // unless the Deployment Group has at least one alarm
    if (autoRollbackConfig.deploymentInAlarm !== false) {
        if (alarms.length > 0) {
            events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM);
        }
        else if (autoRollbackConfig.deploymentInAlarm === true) {
            throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate " +
                "at least one CloudWatch alarm with the Deployment Group");
        }
    }
    return events.length > 0
        ? {
            enabled: true,
            events,
        }
        : undefined;
}
exports.renderAutoRollbackConfiguration = renderAutoRollbackConfiguration;
//# sourceMappingURL=data:application/json;base64,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