# CLASP.Python
**C**ommand-**L**ine **A**rgument **S**orting and **P**arsing for Python

## Table of Contents

1. [Introduction](#introduction)
2. [Installation](#installation)
3. [Components](#components)
4. [Examples](#examples)
5. [Project Information](#project-information)

## Introduction

**CLASP** stands for **C**ommand-**L**ine **A**rgument **S**orting and
**P**arsing. The first CLASP library was a C library with a C++ wrapper. There
have been several implementations in other languages. **CLASP.Python** is the
Python version.

## Installation & usage

Install via **pip** or **pip3**, as in:

```
	pip3 install pyclasp
```

Use via **import**:

```Python

import pyclasp
```

or, as we prefer,

```Python

import pyclasp as clasp
```

## Components

TBC

## Examples

Examples are provided in the ```examples``` directory, along with a markdown description for each. A detailed list TOC of them is provided in [EXAMPLES.md](./EXAMPLES.md).

## Project Information

### Where to get help

[GitHub Page](https://github.com/synesissoftware/CLASP.Python "GitHub Page")

### Contribution guidelines

Defect reports, feature requests, and pull requests are welcome on https://github.com/synesissoftware/CLASP.Python.

### Dependencies

### Related projects

* [**CLASP**](https://github.com/synesissoftware/CLASP/)
* [**CLASP.Go**](https://github.com/synesissoftware/CLASP.Go/)
* [**CLASP.js**](https://github.com/synesissoftware/CLASP.js/)
* [**CLASP.NET**](https://github.com/synesissoftware/CLASP.NET/)
* [**CLASP.Ruby**](https://github.com/synesissoftware/CLASP.Ruby/)
* [**libCLImate.Ruby**](https://github.com/synesissoftware/libCLImate.Ruby/)

### License

**CLASP.Python** is released under the 3-clause BSD license. See [LICENSE](./LICENSE) for details.

