# QPrism

## Overview
The QPrism Python package serves as a quality assessment toolbox for data collected using sensors in smartphones and wearables (eg. accelerometer, gyroscope, audio and video). The package leverages digital signal and image processing techniques along with machine learning algorithms to assess the quality of sensor data covering data availability, interpretability, noise contamination and consistency. QPrism is completely data-driven, requiring no a priori data assumptions or application-specific parameter tuning to generate a comprehensive data quality report.



## Installation

The installation can be done with pip. Since pip does not resolve the dependencies' version efficiently, please install QPrism with the following steps.

  ```
  $ python3 -m pip install --upgrade pip
  ```

  ```
  $ pip install -r https://raw.githubusercontent.com/aid4mh/QPrism/main/requirements.txt
  ```

  ```
  $ pip install --no-deps QPrism
  ```


## Documentation

The full documentation for QPrism can be accessed [here](https://qprism.readthedocs.io/en/latest/).
 



## Examples:

We have provided throughout demo notebooks in Google Colab covered all functions. 

The notebooks can be accessed [here](https://github.com/aid4mh/QPrism/tree/main/tests). 

Note: In the sensor folder, it also contains notebooks that can validate each metric we have created,
and a script demo that can be adopted by user with minor modifications. 

Detailed explanation for the provided examples can be found in the [documentation](https://qprism.readthedocs.io/en/latest/)


## Contributing to the project
We welcome and encourage project contributions! Please see the [CONTRIBUTING.md](https://github.com/aid4mh/QPrism/blob/main/CONTRIBUTING.md) for details.

## Acknowledgments

The development of QPrism package is supported by Krembil Foundation.

The authors also like to acknowledge Aditi Surendra for designing the module function illustration.

## Authors
- [@Ramzi Halabi](https://github.com/RamziHalabi)
- [@RahaviSelvarajan](https://github.com/RahaviSelvarajan)
- [@Jana-kabrit](https://github.com/Jana-kabrit)
- [@ZixiongLin1](https://github.com/ZixiongLin1)
- [@apratap](https://github.com/apratap)


## License
   
   [MIT License](https://github.com/aid4mh/QPrism/blob/main/LICENSE)
    
