# This file has been autogenerated by the pywayland scanner

# Copyright © 2014      Jonas Ådahl
# Copyright © 2015      Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlRegion


class ZwpLockedPointerV1(Interface):
    """Receive relative pointer motion events

    The wp_locked_pointer interface represents a locked pointer state.

    While the lock of this object is active, the
    :class:`~pywayland.protocol.wayland.WlPointer` objects of the associated
    seat will not emit any :func:`WlPointer.motion()
    <pywayland.protocol.wayland.WlPointer.motion>` events.

    This object will send the event 'locked' when the lock is activated.
    Whenever the lock is activated, it is guaranteed that the locked surface
    will already have received pointer focus and that the pointer will be
    within the region passed to the request creating this object.

    To unlock the pointer, send the destroy request. This will also destroy the
    wp_locked_pointer object.

    If the compositor decides to unlock the pointer the unlocked event is sent.
    See wp_locked_pointer.unlock for details.

    When unlocking, the compositor may warp the cursor position to the set
    cursor position hint. If it does, it will not result in any relative motion
    events emitted via wp_relative_pointer.

    If the surface the lock was requested on is destroyed and the lock is not
    yet activated, the wp_locked_pointer object is now defunct and must be
    destroyed.
    """

    name = "zwp_locked_pointer_v1"
    version = 1


class ZwpLockedPointerV1Proxy(Proxy):
    interface = ZwpLockedPointerV1

    @ZwpLockedPointerV1.request()
    def destroy(self):
        """Destroy the locked pointer object

        Destroy the locked pointer object. If applicable, the compositor will
        unlock the pointer.
        """
        self._marshal(0)
        self._destroy()

    @ZwpLockedPointerV1.request(
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
    )
    def set_cursor_position_hint(self, surface_x, surface_y):
        """Set the pointer cursor position hint

        Set the cursor position hint relative to the top left corner of the
        surface.

        If the client is drawing its own cursor, it should update the position
        hint to the position of its own cursor. A compositor may use this
        information to warp the pointer upon unlock in order to avoid pointer
        jumps.

        The cursor position hint is double buffered. The new hint will only
        take effect when the associated surface gets it pending state applied.
        See :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` for details.

        :param surface_x:
            surface-local x coordinate
        :type surface_x:
            `ArgumentType.Fixed`
        :param surface_y:
            surface-local y coordinate
        :type surface_y:
            `ArgumentType.Fixed`
        """
        self._marshal(1, surface_x, surface_y)

    @ZwpLockedPointerV1.request(
        Argument(ArgumentType.Object, interface=WlRegion, nullable=True),
    )
    def set_region(self, region):
        """Set a new lock region

        Set a new region used to lock the pointer.

        The new lock region is double-buffered. The new lock region will only
        take effect when the associated surface gets its pending state applied.
        See :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` for details.

        For details about the lock region, see wp_locked_pointer.

        :param region:
            region of surface
        :type region:
            :class:`~pywayland.protocol.wayland.WlRegion` or `None`
        """
        self._marshal(2, region)


class ZwpLockedPointerV1Resource(Resource):
    interface = ZwpLockedPointerV1

    @ZwpLockedPointerV1.event()
    def locked(self):
        """Lock activation event

        Notification that the pointer lock of the seat's pointer is activated.
        """
        self._post_event(0)

    @ZwpLockedPointerV1.event()
    def unlocked(self):
        """Lock deactivation event

        Notification that the pointer lock of the seat's pointer is no longer
        active. If this is a oneshot pointer lock (see
        wp_pointer_constraints.lifetime) this object is now defunct and should
        be destroyed. If this is a persistent pointer lock (see
        wp_pointer_constraints.lifetime) this pointer lock may again reactivate
        in the future.
        """
        self._post_event(1)


class ZwpLockedPointerV1Global(Global):
    interface = ZwpLockedPointerV1


ZwpLockedPointerV1._gen_c()
ZwpLockedPointerV1.proxy_class = ZwpLockedPointerV1Proxy
ZwpLockedPointerV1.resource_class = ZwpLockedPointerV1Resource
ZwpLockedPointerV1.global_class = ZwpLockedPointerV1Global
