"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.captureStackTrace = void 0;
function captureStackTrace(below) {
    if (process.env.CDK_DISABLE_STACK_TRACE) {
        return ['stack traces disabled'];
    }
    below = below || captureStackTrace; // hide myself if nothing else
    const object = { stack: '' };
    const previousLimit = Error.stackTraceLimit;
    try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
    }
    finally {
        Error.stackTraceLimit = previousLimit;
    }
    if (!object.stack) {
        return [];
    }
    return object.stack.split('\n').slice(1).map(s => s.replace(/^\s*at\s+/, ''));
}
exports.captureStackTrace = captureStackTrace;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2stdHJhY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFjay10cmFjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxTQUFnQixpQkFBaUIsQ0FBQyxLQUFnQjtJQUM5QyxJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMsdUJBQXVCLEVBQUU7UUFDckMsT0FBTyxDQUFDLHVCQUF1QixDQUFDLENBQUM7S0FDcEM7SUFDRCxLQUFLLEdBQUcsS0FBSyxJQUFJLGlCQUFpQixDQUFDLENBQUMsOEJBQThCO0lBQ2xFLE1BQU0sTUFBTSxHQUFHLEVBQUUsS0FBSyxFQUFFLEVBQUUsRUFBRSxDQUFDO0lBQzdCLE1BQU0sYUFBYSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7SUFDNUMsSUFBSTtRQUNBLEtBQUssQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2hELEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsS0FBSyxDQUFDLENBQUM7S0FDMUM7WUFDTztRQUNKLEtBQUssQ0FBQyxlQUFlLEdBQUcsYUFBYSxDQUFDO0tBQ3pDO0lBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUU7UUFDZixPQUFPLEVBQUUsQ0FBQztLQUNiO0lBQ0QsT0FBTyxNQUFNLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQztBQUNsRixDQUFDO0FBbEJELDhDQWtCQyIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBmdW5jdGlvbiBjYXB0dXJlU3RhY2tUcmFjZShiZWxvdz86IEZ1bmN0aW9uKTogc3RyaW5nW10ge1xuICAgIGlmIChwcm9jZXNzLmVudi5DREtfRElTQUJMRV9TVEFDS19UUkFDRSkge1xuICAgICAgICByZXR1cm4gWydzdGFjayB0cmFjZXMgZGlzYWJsZWQnXTtcbiAgICB9XG4gICAgYmVsb3cgPSBiZWxvdyB8fCBjYXB0dXJlU3RhY2tUcmFjZTsgLy8gaGlkZSBteXNlbGYgaWYgbm90aGluZyBlbHNlXG4gICAgY29uc3Qgb2JqZWN0ID0geyBzdGFjazogJycgfTtcbiAgICBjb25zdCBwcmV2aW91c0xpbWl0ID0gRXJyb3Iuc3RhY2tUcmFjZUxpbWl0O1xuICAgIHRyeSB7XG4gICAgICAgIEVycm9yLnN0YWNrVHJhY2VMaW1pdCA9IE51bWJlci5NQVhfU0FGRV9JTlRFR0VSO1xuICAgICAgICBFcnJvci5jYXB0dXJlU3RhY2tUcmFjZShvYmplY3QsIGJlbG93KTtcbiAgICB9XG4gICAgZmluYWxseSB7XG4gICAgICAgIEVycm9yLnN0YWNrVHJhY2VMaW1pdCA9IHByZXZpb3VzTGltaXQ7XG4gICAgfVxuICAgIGlmICghb2JqZWN0LnN0YWNrKSB7XG4gICAgICAgIHJldHVybiBbXTtcbiAgICB9XG4gICAgcmV0dXJuIG9iamVjdC5zdGFjay5zcGxpdCgnXFxuJykuc2xpY2UoMSkubWFwKHMgPT4gcy5yZXBsYWNlKC9eXFxzKmF0XFxzKy8sICcnKSk7XG59XG4iXX0=