"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = void 0;
const fs = require("fs");
const os = require("os");
const path = require("path");
const copy_1 = require("./copy");
const fingerprint_1 = require("./fingerprint");
__exportStar(require("./options"), exports);
/**
 * File system utilities.
 */
class FileSystem {
    /**
     * Copies an entire directory structure.
     * @param srcDir Source directory
     * @param destDir Destination directory
     * @param options options
     * @param rootDir Root directory to calculate exclusions from
     */
    static copyDirectory(srcDir, destDir, options = {}, rootDir) {
        return copy_1.copyDirectory(srcDir, destDir, options, rootDir);
    }
    /**
     * Produces fingerprint based on the contents of a single file or an entire directory tree.
     *
     * The fingerprint will also include:
     * 1. An extra string if defined in `options.extra`.
     * 2. The set of exclude patterns, if defined in `options.exclude`
     * 3. The symlink follow mode value.
     *
     * @param fileOrDirectory The directory or file to fingerprint
     * @param options Fingerprinting options
     */
    static fingerprint(fileOrDirectory, options = {}) {
        return fingerprint_1.fingerprint(fileOrDirectory, options);
    }
    /**
     * Checks whether a directory is empty
     *
     * @param dir The directory to check
     */
    static isEmpty(dir) {
        return fs.readdirSync(dir).length === 0;
    }
    /**
     * The real path of the system temp directory
     */
    static get tmpdir() {
        if (FileSystem._tmpdir) {
            return FileSystem._tmpdir;
        }
        FileSystem._tmpdir = fs.realpathSync(os.tmpdir());
        return FileSystem._tmpdir;
    }
    /**
     * Creates a unique temporary directory in the **system temp directory**.
     *
     * @param prefix A prefix for the directory name. Six random characters
     * will be generated and appended behind this prefix.
     */
    static mkdtemp(prefix) {
        return fs.mkdtempSync(path.join(FileSystem.tmpdir, prefix));
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7O0FBQUEseUJBQXlCO0FBQ3pCLHlCQUF5QjtBQUN6Qiw2QkFBNkI7QUFDN0IsaUNBQXVDO0FBQ3ZDLCtDQUE0QztBQUU1Qyw0Q0FBMEI7QUFDMUI7O0dBRUc7QUFDSCxNQUFhLFVBQVU7SUFDbkI7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLGFBQWEsQ0FBQyxNQUFjLEVBQUUsT0FBZSxFQUFFLFVBQXVCLEVBQUUsRUFBRSxPQUFnQjtRQUNwRyxPQUFPLG9CQUFhLENBQUMsTUFBTSxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDNUQsQ0FBQztJQUNEOzs7Ozs7Ozs7O09BVUc7SUFDSSxNQUFNLENBQUMsV0FBVyxDQUFDLGVBQXVCLEVBQUUsVUFBOEIsRUFBRTtRQUMvRSxPQUFPLHlCQUFXLENBQUMsZUFBZSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFDRDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFXO1FBQzdCLE9BQU8sRUFBRSxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFDRDs7T0FFRztJQUNJLE1BQU0sS0FBSyxNQUFNO1FBQ3BCLElBQUksVUFBVSxDQUFDLE9BQU8sRUFBRTtZQUNwQixPQUFPLFVBQVUsQ0FBQyxPQUFPLENBQUM7U0FDN0I7UUFDRCxVQUFVLENBQUMsT0FBTyxHQUFHLEVBQUUsQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7UUFDbEQsT0FBTyxVQUFVLENBQUMsT0FBTyxDQUFDO0lBQzlCLENBQUM7SUFDRDs7Ozs7T0FLRztJQUNJLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBYztRQUNoQyxPQUFPLEVBQUUsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDaEUsQ0FBQztDQUVKO0FBckRELGdDQXFEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzJztcbmltcG9ydCAqIGFzIG9zIGZyb20gJ29zJztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBjb3B5RGlyZWN0b3J5IH0gZnJvbSAnLi9jb3B5JztcbmltcG9ydCB7IGZpbmdlcnByaW50IH0gZnJvbSAnLi9maW5nZXJwcmludCc7XG5pbXBvcnQgeyBDb3B5T3B0aW9ucywgRmluZ2VycHJpbnRPcHRpb25zIH0gZnJvbSAnLi9vcHRpb25zJztcbmV4cG9ydCAqIGZyb20gJy4vb3B0aW9ucyc7XG4vKipcbiAqIEZpbGUgc3lzdGVtIHV0aWxpdGllcy5cbiAqL1xuZXhwb3J0IGNsYXNzIEZpbGVTeXN0ZW0ge1xuICAgIC8qKlxuICAgICAqIENvcGllcyBhbiBlbnRpcmUgZGlyZWN0b3J5IHN0cnVjdHVyZS5cbiAgICAgKiBAcGFyYW0gc3JjRGlyIFNvdXJjZSBkaXJlY3RvcnlcbiAgICAgKiBAcGFyYW0gZGVzdERpciBEZXN0aW5hdGlvbiBkaXJlY3RvcnlcbiAgICAgKiBAcGFyYW0gb3B0aW9ucyBvcHRpb25zXG4gICAgICogQHBhcmFtIHJvb3REaXIgUm9vdCBkaXJlY3RvcnkgdG8gY2FsY3VsYXRlIGV4Y2x1c2lvbnMgZnJvbVxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgY29weURpcmVjdG9yeShzcmNEaXI6IHN0cmluZywgZGVzdERpcjogc3RyaW5nLCBvcHRpb25zOiBDb3B5T3B0aW9ucyA9IHt9LCByb290RGlyPzogc3RyaW5nKSB7XG4gICAgICAgIHJldHVybiBjb3B5RGlyZWN0b3J5KHNyY0RpciwgZGVzdERpciwgb3B0aW9ucywgcm9vdERpcik7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIFByb2R1Y2VzIGZpbmdlcnByaW50IGJhc2VkIG9uIHRoZSBjb250ZW50cyBvZiBhIHNpbmdsZSBmaWxlIG9yIGFuIGVudGlyZSBkaXJlY3RvcnkgdHJlZS5cbiAgICAgKlxuICAgICAqIFRoZSBmaW5nZXJwcmludCB3aWxsIGFsc28gaW5jbHVkZTpcbiAgICAgKiAxLiBBbiBleHRyYSBzdHJpbmcgaWYgZGVmaW5lZCBpbiBgb3B0aW9ucy5leHRyYWAuXG4gICAgICogMi4gVGhlIHNldCBvZiBleGNsdWRlIHBhdHRlcm5zLCBpZiBkZWZpbmVkIGluIGBvcHRpb25zLmV4Y2x1ZGVgXG4gICAgICogMy4gVGhlIHN5bWxpbmsgZm9sbG93IG1vZGUgdmFsdWUuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gZmlsZU9yRGlyZWN0b3J5IFRoZSBkaXJlY3Rvcnkgb3IgZmlsZSB0byBmaW5nZXJwcmludFxuICAgICAqIEBwYXJhbSBvcHRpb25zIEZpbmdlcnByaW50aW5nIG9wdGlvbnNcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIGZpbmdlcnByaW50KGZpbGVPckRpcmVjdG9yeTogc3RyaW5nLCBvcHRpb25zOiBGaW5nZXJwcmludE9wdGlvbnMgPSB7fSkge1xuICAgICAgICByZXR1cm4gZmluZ2VycHJpbnQoZmlsZU9yRGlyZWN0b3J5LCBvcHRpb25zKTtcbiAgICB9XG4gICAgLyoqXG4gICAgICogQ2hlY2tzIHdoZXRoZXIgYSBkaXJlY3RvcnkgaXMgZW1wdHlcbiAgICAgKlxuICAgICAqIEBwYXJhbSBkaXIgVGhlIGRpcmVjdG9yeSB0byBjaGVja1xuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgaXNFbXB0eShkaXI6IHN0cmluZyk6IGJvb2xlYW4ge1xuICAgICAgICByZXR1cm4gZnMucmVhZGRpclN5bmMoZGlyKS5sZW5ndGggPT09IDA7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIFRoZSByZWFsIHBhdGggb2YgdGhlIHN5c3RlbSB0ZW1wIGRpcmVjdG9yeVxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgZ2V0IHRtcGRpcigpOiBzdHJpbmcge1xuICAgICAgICBpZiAoRmlsZVN5c3RlbS5fdG1wZGlyKSB7XG4gICAgICAgICAgICByZXR1cm4gRmlsZVN5c3RlbS5fdG1wZGlyO1xuICAgICAgICB9XG4gICAgICAgIEZpbGVTeXN0ZW0uX3RtcGRpciA9IGZzLnJlYWxwYXRoU3luYyhvcy50bXBkaXIoKSk7XG4gICAgICAgIHJldHVybiBGaWxlU3lzdGVtLl90bXBkaXI7XG4gICAgfVxuICAgIC8qKlxuICAgICAqIENyZWF0ZXMgYSB1bmlxdWUgdGVtcG9yYXJ5IGRpcmVjdG9yeSBpbiB0aGUgKipzeXN0ZW0gdGVtcCBkaXJlY3RvcnkqKi5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBwcmVmaXggQSBwcmVmaXggZm9yIHRoZSBkaXJlY3RvcnkgbmFtZS4gU2l4IHJhbmRvbSBjaGFyYWN0ZXJzXG4gICAgICogd2lsbCBiZSBnZW5lcmF0ZWQgYW5kIGFwcGVuZGVkIGJlaGluZCB0aGlzIHByZWZpeC5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIG1rZHRlbXAocHJlZml4OiBzdHJpbmcpOiBzdHJpbmcge1xuICAgICAgICByZXR1cm4gZnMubWtkdGVtcFN5bmMocGF0aC5qb2luKEZpbGVTeXN0ZW0udG1wZGlyLCBwcmVmaXgpKTtcbiAgICB9XG4gICAgcHJpdmF0ZSBzdGF0aWMgX3RtcGRpcj86IHN0cmluZztcbn1cbiJdfQ==