"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnInclude = void 0;
const cfn_element_1 = require("./cfn-element");
/**
 * Includes a CloudFormation template into a stack. All elements of the template will be merged into
 * the current stack, together with any elements created programmatically.
 */
class CfnInclude extends cfn_element_1.CfnElement {
    /**
     * Creates an adopted template construct. The template will be incorporated into the stack as-is with no changes at all.
     * This means that logical IDs of entities within this template may conflict with logical IDs of entities that are part of the
     * stack.
     * @param scope The parent construct of this template
     * @param id The ID of this construct
     * @param props Initialization properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.template = props.template;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return this.template;
    }
}
exports.CfnInclude = CfnInclude;
//# sourceMappingURL=data:application/json;base64,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