"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCondition = void 0;
const cfn_element_1 = require("./cfn-element");
/**
 * Represents a CloudFormation condition, for resources which must be conditionally created and
 * the determination must be made at deploy time.
 */
class CfnCondition extends cfn_element_1.CfnElement {
    /**
     * Build a new condition. The condition must be constructed with a condition token,
     * that the condition is based on.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.expression = props && props.expression;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        if (!this.expression) {
            return {};
        }
        return {
            Conditions: {
                [this.logicalId]: this.expression,
            },
        };
    }
    /**
     * Synthesizes the condition.
     */
    resolve(_context) {
        return { Condition: this.logicalId };
    }
}
exports.CfnCondition = CfnCondition;
//# sourceMappingURL=data:application/json;base64,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