"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schedule = void 0;
/**
 * Schedule for canary runs
 */
class Schedule {
    constructor(
    /**
     * The Schedule expression
     */
    expressionString) {
        this.expressionString = expressionString;
    }
    /**
     * The canary will be executed once.
     */
    static once() {
        return new Schedule('rate(0 minutes)');
    }
    /**
     * Construct a schedule from a literal schedule expression. The expression must be in a `rate(number units)` format.
     * For example, `Schedule.expression('rate(10 minutes)')`
     *
     * @param expression The expression to use.
     */
    static expression(expression) {
        return new Schedule(expression);
    }
    /**
     * Construct a schedule from an interval. Allowed values: 0 (for a single run) or between 1 and 60 minutes.
     * To specify a single run, you can use `Schedule.once()`.
     *
     * @param interval The interval at which to run the canary
     */
    static rate(interval) {
        const minutes = interval.toMinutes();
        if (minutes > 60) {
            throw new Error('Schedule duration must be between 1 and 60 minutes');
        }
        if (minutes === 0) {
            return Schedule.once();
        }
        if (minutes === 1) {
            return new Schedule('rate(1 minute)');
        }
        return new Schedule(`rate(${minutes} minutes)`);
    }
}
exports.Schedule = Schedule;
//# sourceMappingURL=data:application/json;base64,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