"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomState = void 0;
const __1 = require("..");
const state_1 = require("./state");
/**
 * State defined by supplying Amazon States Language (ASL) in the state machine.
 *
 * @experimental
 */
class CustomState extends state_1.State {
    constructor(scope, id, props) {
        super(scope, id, {});
        this.endStates = [this];
        this.stateJson = props.stateJson;
    }
    /**
     * Continue normal execution with the given state
     */
    next(next) {
        super.makeNext(next.startState);
        return __1.Chain.sequence(this, next);
    }
    /**
     * Returns the Amazon States Language object for this state
     */
    toStateJson() {
        return {
            ...this.renderNextEnd(),
            ...this.stateJson,
        };
    }
}
exports.CustomState = CustomState;
//# sourceMappingURL=data:application/json;base64,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