"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsInvokeActivity = void 0;
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 */
class StepFunctionsInvokeActivity extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.taskMetrics = {
            metricDimensions: { ActivityArn: this.props.activity.activityArn },
            metricPrefixSingular: 'Activity',
            metricPrefixPlural: 'Activities',
        };
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: this.props.activity.activityArn,
        };
    }
}
exports.StepFunctionsInvokeActivity = StepFunctionsInvokeActivity;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW52b2tlLWFjdGl2aXR5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW52b2tlLWFjdGl2aXR5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLGtEQUFrRCxDQUFDLDZEQUE2RDtBQVdoSDs7OztHQUlHO0FBQ0gsTUFBYSwyQkFBNEIsU0FBUSxHQUFHLENBQUMsYUFBYTtJQUk5RCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFtQixLQUF1QztRQUNsRyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQURtQyxVQUFLLEdBQUwsS0FBSyxDQUFrQztRQUVsRyxJQUFJLENBQUMsV0FBVyxHQUFHO1lBQ2YsZ0JBQWdCLEVBQUUsRUFBRSxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsV0FBVyxFQUFFO1lBQ2xFLG9CQUFvQixFQUFFLFVBQVU7WUFDaEMsa0JBQWtCLEVBQUUsWUFBWTtTQUNuQyxDQUFDO0lBQ04sQ0FBQztJQUNEOztPQUVHO0lBQ08sV0FBVztRQUNqQixPQUFPO1lBQ0gsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLFdBQVc7U0FDNUMsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQXBCRCxrRUFvQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSBcIi4uLy4uLy4uL2F3cy1pYW1cIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nXG5pbXBvcnQgKiBhcyBzZm4gZnJvbSBcIi4uLy4uLy4uL2F3cy1zdGVwZnVuY3Rpb25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc3RlcGZ1bmN0aW9ucydcbmltcG9ydCAqIGFzIGNkayBmcm9tIFwiLi4vLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbi8qKlxuICogUHJvcGVydGllcyBmb3IgaW52b2tpbmcgYW4gQWN0aXZpdHkgd29ya2VyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3RlcEZ1bmN0aW9uc0ludm9rZUFjdGl2aXR5UHJvcHMgZXh0ZW5kcyBzZm4uVGFza1N0YXRlQmFzZVByb3BzIHtcbiAgICAvKipcbiAgICAgKiBTdGVwIEZ1bmN0aW9ucyBBY3Rpdml0eSB0byBpbnZva2VcbiAgICAgKi9cbiAgICByZWFkb25seSBhY3Rpdml0eTogc2ZuLklBY3Rpdml0eTtcbn1cbi8qKlxuICogQSBTdGVwIEZ1bmN0aW9ucyBUYXNrIHRvIGludm9rZSBhbiBBY3Rpdml0eSB3b3JrZXIuXG4gKlxuICogQW4gQWN0aXZpdHkgY2FuIGJlIHVzZWQgZGlyZWN0bHkgYXMgYSBSZXNvdXJjZS5cbiAqL1xuZXhwb3J0IGNsYXNzIFN0ZXBGdW5jdGlvbnNJbnZva2VBY3Rpdml0eSBleHRlbmRzIHNmbi5UYXNrU3RhdGVCYXNlIHtcbiAgICBwcm90ZWN0ZWQgcmVhZG9ubHkgdGFza01ldHJpY3M/OiBzZm4uVGFza01ldHJpY3NDb25maWc7XG4gICAgLy8gTm8gSUFNIHBlcm1pc3Npb25zIG5lY2Vzc2FyeSwgZXhlY3V0aW9uIHJvbGUgaW1wbGljaXRseSBoYXMgQWN0aXZpdHkgcGVybWlzc2lvbnMuXG4gICAgcHJvdGVjdGVkIHJlYWRvbmx5IHRhc2tQb2xpY2llcz86IGlhbS5Qb2xpY3lTdGF0ZW1lbnRbXTtcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBwcm9wczogU3RlcEZ1bmN0aW9uc0ludm9rZUFjdGl2aXR5UHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gICAgICAgIHRoaXMudGFza01ldHJpY3MgPSB7XG4gICAgICAgICAgICBtZXRyaWNEaW1lbnNpb25zOiB7IEFjdGl2aXR5QXJuOiB0aGlzLnByb3BzLmFjdGl2aXR5LmFjdGl2aXR5QXJuIH0sXG4gICAgICAgICAgICBtZXRyaWNQcmVmaXhTaW5ndWxhcjogJ0FjdGl2aXR5JyxcbiAgICAgICAgICAgIG1ldHJpY1ByZWZpeFBsdXJhbDogJ0FjdGl2aXRpZXMnLFxuICAgICAgICB9O1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwcm90ZWN0ZWQgX3JlbmRlclRhc2soKTogYW55IHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIFJlc291cmNlOiB0aGlzLnByb3BzLmFjdGl2aXR5LmFjdGl2aXR5QXJuLFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==