"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceGroupModifyConfigPropertyToJson = exports.BootstrapActionConfigToJson = exports.PlacementTypePropertyToJson = exports.InstanceGroupConfigPropertyToJson = exports.AutoScalingPolicyPropertyToJson = exports.ScalingRulePropertyToJson = exports.ScalingActionPropertyToJson = exports.ScalingTriggerPropertyToJson = exports.MetricDimensionPropertyToJson = exports.InstanceFleetConfigPropertyToJson = exports.InstanceFleetProvisioningSpecificationsPropertyToJson = exports.InstanceTypeConfigPropertyToJson = exports.EbsConfigurationPropertyToJson = exports.EbsBlockDeviceConfigPropertyToJson = exports.ConfigurationPropertyToJson = exports.ApplicationConfigPropertyToJson = exports.InstancesConfigPropertyToJson = exports.KerberosAttributesPropertyToJson = void 0;
const cdk = require("../../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Render the KerberosAttributesProperty as JSON
 *
 * @param property
 */
function KerberosAttributesPropertyToJson(property) {
    return {
        ADDomainJoinPassword: cdk.stringToCloudFormation(property.adDomainJoinPassword),
        ADDomainJoinUser: cdk.stringToCloudFormation(property.adDomainJoinUser),
        CrossRealmTrustPrincipalPassword: cdk.stringToCloudFormation(property.crossRealmTrustPrincipalPassword),
        KdcAdminPassword: cdk.stringToCloudFormation(property.kdcAdminPassword),
        Realm: cdk.stringToCloudFormation(property.realm),
    };
}
exports.KerberosAttributesPropertyToJson = KerberosAttributesPropertyToJson;
/**
 * Render the InstancesConfigProperty to JSON
 *
 * @param property
 */
function InstancesConfigPropertyToJson(property) {
    return {
        AdditionalMasterSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(property.additionalMasterSecurityGroups),
        AdditionalSlaveSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(property.additionalSlaveSecurityGroups),
        Ec2KeyName: cdk.stringToCloudFormation(property.ec2KeyName),
        Ec2SubnetId: cdk.stringToCloudFormation(property.ec2SubnetId),
        Ec2SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(property.ec2SubnetIds),
        EmrManagedMasterSecurityGroup: cdk.stringToCloudFormation(property.emrManagedMasterSecurityGroup),
        EmrManagedSlaveSecurityGroup: cdk.stringToCloudFormation(property.emrManagedSlaveSecurityGroup),
        HadoopVersion: cdk.stringToCloudFormation(property.hadoopVersion),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        InstanceFleets: cdk.listMapper(InstanceFleetConfigPropertyToJson)(property.instanceFleets),
        InstanceGroups: cdk.listMapper(InstanceGroupConfigPropertyToJson)(property.instanceGroups),
        KeepJobFlowAliveWhenNoSteps: true,
        MasterInstanceType: cdk.stringToCloudFormation(property.masterInstanceType),
        Placement: property.placement === undefined ? property.placement : PlacementTypePropertyToJson(property.placement),
        ServiceAccessSecurityGroup: cdk.stringToCloudFormation(property.serviceAccessSecurityGroup),
        SlaveInstanceType: cdk.stringToCloudFormation(property.slaveInstanceType),
        TerminationProtected: cdk.booleanToCloudFormation(property.terminationProtected),
    };
}
exports.InstancesConfigPropertyToJson = InstancesConfigPropertyToJson;
/**
 * Render the ApplicationConfigProperty as JSON
 *
 * @param property
 */
function ApplicationConfigPropertyToJson(property) {
    return {
        Name: cdk.stringToCloudFormation(property.name),
        Args: cdk.listMapper(cdk.stringToCloudFormation)(property.args),
        Version: cdk.stringToCloudFormation(property.version),
        AdditionalInfo: cdk.objectToCloudFormation(property.additionalInfo),
    };
}
exports.ApplicationConfigPropertyToJson = ApplicationConfigPropertyToJson;
/**
 * Render the ConfigurationProperty as JSON
 *
 * @param property
 */
function ConfigurationPropertyToJson(property) {
    return {
        Classification: cdk.stringToCloudFormation(property.classification),
        Properties: cdk.objectToCloudFormation(property.properties),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
    };
}
exports.ConfigurationPropertyToJson = ConfigurationPropertyToJson;
/**
 * Render the EbsBlockDeviceConfigProperty as JSON
 *
 * @param property
 */
function EbsBlockDeviceConfigPropertyToJson(property) {
    var _a, _b;
    return {
        VolumeSpecification: {
            Iops: cdk.numberToCloudFormation(property.volumeSpecification.iops),
            SizeInGB: (_a = property.volumeSpecification.volumeSize) === null || _a === void 0 ? void 0 : _a.toGibibytes(),
            VolumeType: cdk.stringToCloudFormation((_b = property.volumeSpecification.volumeType) === null || _b === void 0 ? void 0 : _b.valueOf()),
        },
        VolumesPerInstance: cdk.numberToCloudFormation(property.volumesPerInstance),
    };
}
exports.EbsBlockDeviceConfigPropertyToJson = EbsBlockDeviceConfigPropertyToJson;
/**
 * Render the EbsConfigurationProperty to JSON
 *
 * @param property
 */
function EbsConfigurationPropertyToJson(property) {
    return {
        EbsBlockDeviceConfigs: cdk.listMapper(EbsBlockDeviceConfigPropertyToJson)(property.ebsBlockDeviceConfigs),
        EbsOptimized: cdk.booleanToCloudFormation(property.ebsOptimized),
    };
}
exports.EbsConfigurationPropertyToJson = EbsConfigurationPropertyToJson;
/**
 * Render the InstanceTypeConfigProperty to JSON]
 *
 * @param property
 */
function InstanceTypeConfigPropertyToJson(property) {
    var _a;
    return {
        BidPrice: cdk.stringToCloudFormation(property.bidPrice),
        BidPriceAsPercentageOfOnDemandPrice: cdk.numberToCloudFormation(property.bidPriceAsPercentageOfOnDemandPrice),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EbsConfiguration: property.ebsConfiguration === undefined ? property.ebsConfiguration : EbsConfigurationPropertyToJson(property.ebsConfiguration),
        InstanceType: cdk.stringToCloudFormation((_a = property.instanceType) === null || _a === void 0 ? void 0 : _a.valueOf()),
        WeightedCapacity: cdk.numberToCloudFormation(property.weightedCapacity),
    };
}
exports.InstanceTypeConfigPropertyToJson = InstanceTypeConfigPropertyToJson;
/**
 * Render the InstanceFleetProvisioningSpecificationsProperty to JSON
 *
 * @param property
 */
function InstanceFleetProvisioningSpecificationsPropertyToJson(property) {
    var _a;
    return {
        SpotSpecification: {
            BlockDurationMinutes: cdk.numberToCloudFormation(property.spotSpecification.blockDurationMinutes),
            TimeoutAction: cdk.stringToCloudFormation((_a = property.spotSpecification.timeoutAction) === null || _a === void 0 ? void 0 : _a.valueOf()),
            TimeoutDurationMinutes: cdk.numberToCloudFormation(property.spotSpecification.timeoutDurationMinutes),
        },
    };
}
exports.InstanceFleetProvisioningSpecificationsPropertyToJson = InstanceFleetProvisioningSpecificationsPropertyToJson;
/**
 * Render the InstanceFleetConfigProperty as JSON
 *
 * @param property
 */
function InstanceFleetConfigPropertyToJson(property) {
    var _a;
    return {
        InstanceFleetType: cdk.stringToCloudFormation((_a = property.instanceFleetType) === null || _a === void 0 ? void 0 : _a.valueOf()),
        InstanceTypeConfigs: cdk.listMapper(InstanceTypeConfigPropertyToJson)(property.instanceTypeConfigs),
        LaunchSpecifications: property.launchSpecifications === undefined
            ? property.launchSpecifications
            : InstanceFleetProvisioningSpecificationsPropertyToJson(property.launchSpecifications),
        Name: cdk.stringToCloudFormation(property.name),
        TargetOnDemandCapacity: cdk.numberToCloudFormation(property.targetOnDemandCapacity),
        TargetSpotCapacity: cdk.numberToCloudFormation(property.targetSpotCapacity),
    };
}
exports.InstanceFleetConfigPropertyToJson = InstanceFleetConfigPropertyToJson;
/**
 * Render the MetricDimensionProperty as JSON
 *
 * @param property
 */
function MetricDimensionPropertyToJson(property) {
    return {
        Key: cdk.stringToCloudFormation(property.key),
        Value: cdk.stringToCloudFormation(property.value),
    };
}
exports.MetricDimensionPropertyToJson = MetricDimensionPropertyToJson;
/**
 * Render the ScalingTriggerProperty to JSON
 *
 * @param property
 */
function ScalingTriggerPropertyToJson(property) {
    var _a, _b, _c;
    return {
        CloudWatchAlarmDefinition: {
            ComparisonOperator: cdk.stringToCloudFormation((_a = property.cloudWatchAlarmDefinition.comparisonOperator) === null || _a === void 0 ? void 0 : _a.valueOf()),
            Dimensions: cdk.listMapper(MetricDimensionPropertyToJson)(property.cloudWatchAlarmDefinition.dimensions),
            EvaluationPeriods: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.evaluationPeriods),
            MetricName: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.metricName),
            Namespace: cdk.stringToCloudFormation(property.cloudWatchAlarmDefinition.namespace),
            Period: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.period.toSeconds()),
            Statistic: cdk.stringToCloudFormation((_b = property.cloudWatchAlarmDefinition.statistic) === null || _b === void 0 ? void 0 : _b.valueOf()),
            Threshold: cdk.numberToCloudFormation(property.cloudWatchAlarmDefinition.threshold),
            Unit: cdk.stringToCloudFormation((_c = property.cloudWatchAlarmDefinition.unit) === null || _c === void 0 ? void 0 : _c.valueOf()),
        },
    };
}
exports.ScalingTriggerPropertyToJson = ScalingTriggerPropertyToJson;
/**
 * Render the ScalingActionProperty to JSON
 *
 * @param property
 */
function ScalingActionPropertyToJson(property) {
    var _a;
    return {
        Market: cdk.stringToCloudFormation((_a = property.market) === null || _a === void 0 ? void 0 : _a.valueOf()),
        SimpleScalingPolicyConfiguration: {
            AdjustmentType: cdk.stringToCloudFormation(property.simpleScalingPolicyConfiguration.adjustmentType),
            CoolDown: cdk.numberToCloudFormation(property.simpleScalingPolicyConfiguration.coolDown),
            ScalingAdjustment: cdk.numberToCloudFormation(property.simpleScalingPolicyConfiguration.scalingAdjustment),
        },
    };
}
exports.ScalingActionPropertyToJson = ScalingActionPropertyToJson;
/**
 * Render the ScalingRuleProperty to JSON
 *
 * @param property
 */
function ScalingRulePropertyToJson(property) {
    return {
        Action: ScalingActionPropertyToJson(property.action),
        Description: cdk.stringToCloudFormation(property.description),
        Name: cdk.stringToCloudFormation(property.name),
        Trigger: ScalingTriggerPropertyToJson(property.trigger),
    };
}
exports.ScalingRulePropertyToJson = ScalingRulePropertyToJson;
/**
 * Render the AutoScalingPolicyProperty to JSON
 *
 * @param property
 */
function AutoScalingPolicyPropertyToJson(property) {
    return {
        Constraints: {
            MaxCapacity: cdk.numberToCloudFormation(property.constraints.maxCapacity),
            MinCapacity: cdk.numberToCloudFormation(property.constraints.minCapacity),
        },
        Rules: cdk.listMapper(ScalingRulePropertyToJson)(property.rules),
    };
}
exports.AutoScalingPolicyPropertyToJson = AutoScalingPolicyPropertyToJson;
/**
 * Render the InstanceGroupConfigProperty to JSON
 *
 * @param property
 */
function InstanceGroupConfigPropertyToJson(property) {
    var _a, _b;
    return {
        AutoScalingPolicy: property.autoScalingPolicy === undefined ? property.autoScalingPolicy : AutoScalingPolicyPropertyToJson(property.autoScalingPolicy),
        BidPrice: cdk.numberToCloudFormation(property.bidPrice),
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EbsConfiguration: property.ebsConfiguration === undefined ? property.ebsConfiguration : EbsConfigurationPropertyToJson(property.ebsConfiguration),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        InstanceRole: cdk.stringToCloudFormation((_a = property.instanceRole) === null || _a === void 0 ? void 0 : _a.valueOf()),
        InstanceType: cdk.stringToCloudFormation(property.instanceType),
        Market: cdk.stringToCloudFormation((_b = property.market) === null || _b === void 0 ? void 0 : _b.valueOf()),
        Name: cdk.stringToCloudFormation(property.name),
    };
}
exports.InstanceGroupConfigPropertyToJson = InstanceGroupConfigPropertyToJson;
/**
 * Render the PlacementTypeProperty to JSON
 *
 * @param property
 */
function PlacementTypePropertyToJson(property) {
    return {
        AvailabilityZone: cdk.stringToCloudFormation(property.availabilityZone),
        AvailabilityZones: cdk.listMapper(cdk.stringToCloudFormation)(property.availabilityZones),
    };
}
exports.PlacementTypePropertyToJson = PlacementTypePropertyToJson;
/**
 * Render the BootstrapActionProperty as JSON
 *
 * @param property
 */
function BootstrapActionConfigToJson(property) {
    return {
        Name: cdk.stringToCloudFormation(property.name),
        ScriptBootstrapAction: {
            Path: cdk.stringToCloudFormation(property.scriptBootstrapAction.path),
            Args: cdk.listMapper(cdk.stringToCloudFormation)(property.scriptBootstrapAction.args),
        },
    };
}
exports.BootstrapActionConfigToJson = BootstrapActionConfigToJson;
/**
 * Render the InstanceGroupModifyConfigProperty to JSON
 *
 * @param property
 */
function InstanceGroupModifyConfigPropertyToJson(property) {
    return {
        Configurations: cdk.listMapper(ConfigurationPropertyToJson)(property.configurations),
        EC2InstanceIdsToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.eC2InstanceIdsToTerminate),
        InstanceCount: cdk.numberToCloudFormation(property.instanceCount),
        ShrinkPolicy: property.shrinkPolicy === undefined ? property.shrinkPolicy : ShrinkPolicyPropertyToJson(property.shrinkPolicy),
    };
}
exports.InstanceGroupModifyConfigPropertyToJson = InstanceGroupModifyConfigPropertyToJson;
/**
 * Render the ShrinkPolicyProperty to JSON
 *
 * @param property
 */
function ShrinkPolicyPropertyToJson(property) {
    var _a;
    return {
        DecommissionTimeout: cdk.numberToCloudFormation((_a = property.decommissionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
        InstanceResizePolicy: property.instanceResizePolicy ? InstanceResizePolicyPropertyToJson(property.instanceResizePolicy) : undefined,
    };
}
/**
 * Render the InstanceResizePolicyProperty to JSON
 *
 * @param property
 */
function InstanceResizePolicyPropertyToJson(property) {
    var _a;
    return {
        InstancesToProtect: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToProtect),
        InstancesToTerminate: cdk.listMapper(cdk.stringToCloudFormation)(property.instancesToTerminate),
        InstanceTerminationTimeout: cdk.numberToCloudFormation((_a = property.instanceTerminationTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds()),
    };
}
//# sourceMappingURL=data:application/json;base64,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