"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueuePolicy = void 0;
const aws_iam_1 = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const sqs_generated_1 = require("./sqs.generated");
/**
 * Applies a policy to SQS queues.
 */
class QueuePolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument();
        new sqs_generated_1.CfnQueuePolicy(this, 'Resource', {
            policyDocument: this.document,
            queues: props.queues.map(q => q.queueUrl),
        });
    }
}
exports.QueuePolicy = QueuePolicy;
//# sourceMappingURL=data:application/json;base64,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