"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WhiteListReceiptFilter = exports.ReceiptFilter = exports.ReceiptFilterPolicy = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const ses_generated_1 = require("./ses.generated");
/**
 * The policy for the receipt filter.
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    /**
     * Allow the ip address or range.
     */
    ReceiptFilterPolicy["ALLOW"] = "Allow";
    /**
     * Block the ip address or range.
     */
    ReceiptFilterPolicy["BLOCK"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter. When instantiated without props, it creates a
 * block all receipt filter.
 */
class ReceiptFilter extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptFilterName,
        });
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: props.ip || '0.0.0.0/0',
                    policy: props.policy || ReceiptFilterPolicy.BLOCK,
                },
                name: this.physicalName,
            },
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
/**
 * A white list receipt filter.
 */
class WhiteListReceiptFilter extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.ALLOW,
            });
        });
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
//# sourceMappingURL=data:application/json;base64,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