"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bounce = exports.BounceTemplate = void 0;
/**
 * A bounce template.
 */
class BounceTemplate {
    constructor(props) {
        this.props = props;
    }
}
exports.BounceTemplate = BounceTemplate;
BounceTemplate.MAILBOX_DOES_NOT_EXIST = new BounceTemplate({
    message: 'Mailbox does not exist',
    smtpReplyCode: '550',
    statusCode: '5.1.1',
});
BounceTemplate.MESSAGE_TOO_LARGE = new BounceTemplate({
    message: 'Message too large',
    smtpReplyCode: '552',
    statusCode: '5.3.4',
});
BounceTemplate.MAILBOX_FULL = new BounceTemplate({
    message: 'Mailbox full',
    smtpReplyCode: '552',
    statusCode: '5.2.2',
});
BounceTemplate.MESSAGE_CONTENT_REJECTED = new BounceTemplate({
    message: 'Message content rejected',
    smtpReplyCode: '500',
    statusCode: '5.6.1',
});
BounceTemplate.TEMPORARY_FAILURE = new BounceTemplate({
    message: 'Temporary failure',
    smtpReplyCode: '450',
    statusCode: '4.0.0',
});
/**
 * Rejects the received email by returning a bounce response to the sender and,
 * optionally, publishes a notification to Amazon SNS.
 */
class Bounce {
    constructor(props) {
        this.props = props;
    }
    bind(_rule) {
        return {
            bounceAction: {
                sender: this.props.sender,
                smtpReplyCode: this.props.template.props.smtpReplyCode,
                message: this.props.template.props.message,
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
                statusCode: this.props.template.props.statusCode,
            },
        };
    }
}
exports.Bounce = Bounce;
//# sourceMappingURL=data:application/json;base64,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