"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CnameInstance = void 0;
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance that is accessible using a domain name (CNAME).
 * @resource AWS::ServiceDiscovery::Instance
 */
class CnameInstance extends instance_1.InstanceBase {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.service.namespace.type === namespace_1.NamespaceType.HTTP) {
            throw new Error('Namespace associated with Service must be a DNS Namespace.');
        }
        if (props.service.dnsRecordType !== service_1.DnsRecordType.CNAME) {
            throw new Error('A `CnameIntance` can only be used with a service using a `CNAME` record.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceId: props.instanceId || this.uniqueInstanceId(),
            serviceId: props.service.serviceId,
            instanceAttributes: {
                AWS_INSTANCE_CNAME: props.instanceCname,
                ...props.customAttributes,
            },
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.cname = props.instanceCname;
    }
}
exports.CnameInstance = CnameInstance;
//# sourceMappingURL=data:application/json;base64,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