"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InterfaceVpcEndpointTarget = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Set an InterfaceVpcEndpoint as a target for an ARecord
 */
class InterfaceVpcEndpointTarget {
    constructor(vpcEndpoint) {
        this.vpcEndpoint = vpcEndpoint;
        this.cfnVpcEndpoint = this.vpcEndpoint.node.findChild('Resource');
    }
    bind(_record) {
        return {
            dnsName: cdk.Fn.select(1, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
            hostedZoneId: cdk.Fn.select(0, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
        };
    }
}
exports.InterfaceVpcEndpointTarget = InterfaceVpcEndpointTarget;
//# sourceMappingURL=data:application/json;base64,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