import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::RoboMaker::Fleet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html
 */
export interface CfnFleetProps {
    /**
     * `AWS::RoboMaker::Fleet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html#cfn-robomaker-fleet-name
     */
    readonly name?: string;
    /**
     * `AWS::RoboMaker::Fleet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html#cfn-robomaker-fleet-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::RoboMaker::Fleet`
 *
 * @cloudformationResource AWS::RoboMaker::Fleet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html
 */
export declare class CfnFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::Fleet";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::RoboMaker::Fleet.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html#cfn-robomaker-fleet-name
     */
    name: string | undefined;
    /**
     * `AWS::RoboMaker::Fleet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-fleet.html#cfn-robomaker-fleet-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RoboMaker::Fleet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnFleetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RoboMaker::Robot`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html
 */
export interface CfnRobotProps {
    /**
     * `AWS::RoboMaker::Robot.Architecture`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-architecture
     */
    readonly architecture: string;
    /**
     * `AWS::RoboMaker::Robot.GreengrassGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-greengrassgroupid
     */
    readonly greengrassGroupId: string;
    /**
     * `AWS::RoboMaker::Robot.Fleet`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-fleet
     */
    readonly fleet?: string;
    /**
     * `AWS::RoboMaker::Robot.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-name
     */
    readonly name?: string;
    /**
     * `AWS::RoboMaker::Robot.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::RoboMaker::Robot`
 *
 * @cloudformationResource AWS::RoboMaker::Robot
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html
 */
export declare class CfnRobot extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::Robot";
    /**
     * `AWS::RoboMaker::Robot.Architecture`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-architecture
     */
    architecture: string;
    /**
     * `AWS::RoboMaker::Robot.GreengrassGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-greengrassgroupid
     */
    greengrassGroupId: string;
    /**
     * `AWS::RoboMaker::Robot.Fleet`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-fleet
     */
    fleet: string | undefined;
    /**
     * `AWS::RoboMaker::Robot.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-name
     */
    name: string | undefined;
    /**
     * `AWS::RoboMaker::Robot.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robot.html#cfn-robomaker-robot-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RoboMaker::Robot`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRobotProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RoboMaker::RobotApplication`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html
 */
export interface CfnRobotApplicationProps {
    /**
     * `AWS::RoboMaker::RobotApplication.RobotSoftwareSuite`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-robotsoftwaresuite
     */
    readonly robotSoftwareSuite: CfnRobotApplication.RobotSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::RobotApplication.Sources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-sources
     */
    readonly sources: Array<CfnRobotApplication.SourceConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::RobotApplication.CurrentRevisionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-currentrevisionid
     */
    readonly currentRevisionId?: string;
    /**
     * `AWS::RoboMaker::RobotApplication.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-name
     */
    readonly name?: string;
    /**
     * `AWS::RoboMaker::RobotApplication.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::RoboMaker::RobotApplication`
 *
 * @cloudformationResource AWS::RoboMaker::RobotApplication
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html
 */
export declare class CfnRobotApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::RobotApplication";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute CurrentRevisionId
     */
    readonly attrCurrentRevisionId: string;
    /**
     * `AWS::RoboMaker::RobotApplication.RobotSoftwareSuite`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-robotsoftwaresuite
     */
    robotSoftwareSuite: CfnRobotApplication.RobotSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::RobotApplication.Sources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-sources
     */
    sources: Array<CfnRobotApplication.SourceConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::RobotApplication.CurrentRevisionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-currentrevisionid
     */
    currentRevisionId: string | undefined;
    /**
     * `AWS::RoboMaker::RobotApplication.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-name
     */
    name: string | undefined;
    /**
     * `AWS::RoboMaker::RobotApplication.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplication.html#cfn-robomaker-robotapplication-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RoboMaker::RobotApplication`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRobotApplicationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnRobotApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-robotsoftwaresuite.html
     */
    interface RobotSoftwareSuiteProperty {
        /**
         * `CfnRobotApplication.RobotSoftwareSuiteProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-robotsoftwaresuite.html#cfn-robomaker-robotapplication-robotsoftwaresuite-name
         */
        readonly name: string;
        /**
         * `CfnRobotApplication.RobotSoftwareSuiteProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-robotsoftwaresuite.html#cfn-robomaker-robotapplication-robotsoftwaresuite-version
         */
        readonly version: string;
    }
}
export declare namespace CfnRobotApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-sourceconfig.html
     */
    interface SourceConfigProperty {
        /**
         * `CfnRobotApplication.SourceConfigProperty.Architecture`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-sourceconfig.html#cfn-robomaker-robotapplication-sourceconfig-architecture
         */
        readonly architecture: string;
        /**
         * `CfnRobotApplication.SourceConfigProperty.S3Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-sourceconfig.html#cfn-robomaker-robotapplication-sourceconfig-s3bucket
         */
        readonly s3Bucket: string;
        /**
         * `CfnRobotApplication.SourceConfigProperty.S3Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-robotapplication-sourceconfig.html#cfn-robomaker-robotapplication-sourceconfig-s3key
         */
        readonly s3Key: string;
    }
}
/**
 * Properties for defining a `AWS::RoboMaker::RobotApplicationVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html
 */
export interface CfnRobotApplicationVersionProps {
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.Application`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-application
     */
    readonly application: string;
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.CurrentRevisionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-currentrevisionid
     */
    readonly currentRevisionId?: string;
}
/**
 * A CloudFormation `AWS::RoboMaker::RobotApplicationVersion`
 *
 * @cloudformationResource AWS::RoboMaker::RobotApplicationVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html
 */
export declare class CfnRobotApplicationVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::RobotApplicationVersion";
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.Application`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-application
     */
    application: string;
    /**
     * `AWS::RoboMaker::RobotApplicationVersion.CurrentRevisionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-robotapplicationversion.html#cfn-robomaker-robotapplicationversion-currentrevisionid
     */
    currentRevisionId: string | undefined;
    /**
     * Create a new `AWS::RoboMaker::RobotApplicationVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRobotApplicationVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::RoboMaker::SimulationApplication`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 */
export interface CfnSimulationApplicationProps {
    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     */
    readonly renderingEngine: CfnSimulationApplication.RenderingEngineProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     */
    readonly robotSoftwareSuite: CfnSimulationApplication.RobotSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     */
    readonly simulationSoftwareSuite: CfnSimulationApplication.SimulationSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     */
    readonly sources: Array<CfnSimulationApplication.SourceConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
     */
    readonly currentRevisionId?: string;
    /**
     * `AWS::RoboMaker::SimulationApplication.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
     */
    readonly name?: string;
    /**
     * `AWS::RoboMaker::SimulationApplication.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplication`
 *
 * @cloudformationResource AWS::RoboMaker::SimulationApplication
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html
 */
export declare class CfnSimulationApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::SimulationApplication";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute CurrentRevisionId
     */
    readonly attrCurrentRevisionId: string;
    /**
     * `AWS::RoboMaker::SimulationApplication.RenderingEngine`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-renderingengine
     */
    renderingEngine: CfnSimulationApplication.RenderingEngineProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.RobotSoftwareSuite`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-robotsoftwaresuite
     */
    robotSoftwareSuite: CfnSimulationApplication.RobotSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.SimulationSoftwareSuite`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite
     */
    simulationSoftwareSuite: CfnSimulationApplication.SimulationSoftwareSuiteProperty | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.Sources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-sources
     */
    sources: Array<CfnSimulationApplication.SourceConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::RoboMaker::SimulationApplication.CurrentRevisionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-currentrevisionid
     */
    currentRevisionId: string | undefined;
    /**
     * `AWS::RoboMaker::SimulationApplication.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-name
     */
    name: string | undefined;
    /**
     * `AWS::RoboMaker::SimulationApplication.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplication.html#cfn-robomaker-simulationapplication-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::RoboMaker::SimulationApplication`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSimulationApplicationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSimulationApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html
     */
    interface RenderingEngineProperty {
        /**
         * `CfnSimulationApplication.RenderingEngineProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html#cfn-robomaker-simulationapplication-renderingengine-name
         */
        readonly name: string;
        /**
         * `CfnSimulationApplication.RenderingEngineProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-renderingengine.html#cfn-robomaker-simulationapplication-renderingengine-version
         */
        readonly version: string;
    }
}
export declare namespace CfnSimulationApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html
     */
    interface RobotSoftwareSuiteProperty {
        /**
         * `CfnSimulationApplication.RobotSoftwareSuiteProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html#cfn-robomaker-simulationapplication-robotsoftwaresuite-name
         */
        readonly name: string;
        /**
         * `CfnSimulationApplication.RobotSoftwareSuiteProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-robotsoftwaresuite.html#cfn-robomaker-simulationapplication-robotsoftwaresuite-version
         */
        readonly version: string;
    }
}
export declare namespace CfnSimulationApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html
     */
    interface SimulationSoftwareSuiteProperty {
        /**
         * `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite-name
         */
        readonly name: string;
        /**
         * `CfnSimulationApplication.SimulationSoftwareSuiteProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-simulationsoftwaresuite.html#cfn-robomaker-simulationapplication-simulationsoftwaresuite-version
         */
        readonly version: string;
    }
}
export declare namespace CfnSimulationApplication {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html
     */
    interface SourceConfigProperty {
        /**
         * `CfnSimulationApplication.SourceConfigProperty.Architecture`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-architecture
         */
        readonly architecture: string;
        /**
         * `CfnSimulationApplication.SourceConfigProperty.S3Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-s3bucket
         */
        readonly s3Bucket: string;
        /**
         * `CfnSimulationApplication.SourceConfigProperty.S3Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-robomaker-simulationapplication-sourceconfig.html#cfn-robomaker-simulationapplication-sourceconfig-s3key
         */
        readonly s3Key: string;
    }
}
/**
 * Properties for defining a `AWS::RoboMaker::SimulationApplicationVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html
 */
export interface CfnSimulationApplicationVersionProps {
    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.Application`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-application
     */
    readonly application: string;
    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.CurrentRevisionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-currentrevisionid
     */
    readonly currentRevisionId?: string;
}
/**
 * A CloudFormation `AWS::RoboMaker::SimulationApplicationVersion`
 *
 * @cloudformationResource AWS::RoboMaker::SimulationApplicationVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html
 */
export declare class CfnSimulationApplicationVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::RoboMaker::SimulationApplicationVersion";
    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.Application`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-application
     */
    application: string;
    /**
     * `AWS::RoboMaker::SimulationApplicationVersion.CurrentRevisionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-robomaker-simulationapplicationversion.html#cfn-robomaker-simulationapplicationversion-currentrevisionid
     */
    currentRevisionId: string | undefined;
    /**
     * Create a new `AWS::RoboMaker::SimulationApplicationVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSimulationApplicationVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
