import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ResourceGroups::Group`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html
 */
export interface CfnGroupProps {
    /**
     * `AWS::ResourceGroups::Group.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-name
     */
    readonly name: string;
    /**
     * `AWS::ResourceGroups::Group.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-description
     */
    readonly description?: string;
    /**
     * `AWS::ResourceGroups::Group.ResourceQuery`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resourcequery
     */
    readonly resourceQuery?: CfnGroup.ResourceQueryProperty | cdk.IResolvable;
    /**
     * `AWS::ResourceGroups::Group.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::ResourceGroups::Group`
 *
 * @cloudformationResource AWS::ResourceGroups::Group
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html
 */
export declare class CfnGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ResourceGroups::Group";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::ResourceGroups::Group.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-name
     */
    name: string;
    /**
     * `AWS::ResourceGroups::Group.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-description
     */
    description: string | undefined;
    /**
     * `AWS::ResourceGroups::Group.ResourceQuery`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resourcequery
     */
    resourceQuery: CfnGroup.ResourceQueryProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ResourceGroups::Group.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ResourceGroups::Group`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html
     */
    interface QueryProperty {
        /**
         * `CfnGroup.QueryProperty.ResourceTypeFilters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html#cfn-resourcegroups-group-query-resourcetypefilters
         */
        readonly resourceTypeFilters?: string[];
        /**
         * `CfnGroup.QueryProperty.StackIdentifier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html#cfn-resourcegroups-group-query-stackidentifier
         */
        readonly stackIdentifier?: string;
        /**
         * `CfnGroup.QueryProperty.TagFilters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html#cfn-resourcegroups-group-query-tagfilters
         */
        readonly tagFilters?: Array<CfnGroup.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-resourcequery.html
     */
    interface ResourceQueryProperty {
        /**
         * `CfnGroup.ResourceQueryProperty.Query`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-resourcequery.html#cfn-resourcegroups-group-resourcequery-query
         */
        readonly query?: CfnGroup.QueryProperty | cdk.IResolvable;
        /**
         * `CfnGroup.ResourceQueryProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-resourcequery.html#cfn-resourcegroups-group-resourcequery-type
         */
        readonly type?: string;
    }
}
export declare namespace CfnGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-tagfilter.html
     */
    interface TagFilterProperty {
        /**
         * `CfnGroup.TagFilterProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-tagfilter.html#cfn-resourcegroups-group-tagfilter-key
         */
        readonly key?: string;
        /**
         * `CfnGroup.TagFilterProperty.Values`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-tagfilter.html#cfn-resourcegroups-group-tagfilter-values
         */
        readonly values?: string[];
    }
}
