"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricFilter = void 0;
const aws_cloudwatch_1 = require("../../aws-cloudwatch"); // Automatically re-written from '@aws-cdk/aws-cloudwatch'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const logs_generated_1 = require("./logs.generated");
/**
 * A filter that extracts information from CloudWatch Logs and emits to CloudWatch Metrics
 */
class MetricFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.metricName = props.metricName;
        this.metricNamespace = props.metricNamespace;
        // It looks odd to map this object to a singleton list, but that's how
        // we're supposed to do it according to the docs.
        //
        // > Currently, you can specify only one metric transformation for
        // > each metric filter. If you want to specify multiple metric
        // > transformations, you must specify multiple metric filters.
        //
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html
        new logs_generated_1.CfnMetricFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            filterPattern: props.filterPattern.logPatternString,
            metricTransformations: [{
                    metricNamespace: props.metricNamespace,
                    metricName: props.metricName,
                    metricValue: props.metricValue !== undefined ? props.metricValue : '1',
                    defaultValue: props.defaultValue,
                }],
        });
    }
    /**
     * Return the given named metric for this Metric Filter
     *
     * @default avg over 5 minutes
     */
    metric(props) {
        return new aws_cloudwatch_1.Metric({
            metricName: this.metricName,
            namespace: this.metricNamespace,
            statistic: 'avg',
            ...props,
        }).attachTo(this);
    }
}
exports.MetricFilter = MetricFilter;
//# sourceMappingURL=data:application/json;base64,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