"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * Use a Lamda Function as the destination for a log subscription
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
    }
    bind(scope, logGroup) {
        const arn = logGroup.logGroupArn;
        this.fn.addPermission('CanInvokeLambda', {
            principal: new iam.ServicePrincipal('logs.amazonaws.com'),
            sourceArn: arn,
            // Using SubScription Filter as scope is okay, since every Subscription Filter has only
            // one destination.
            scope,
        });
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHFDQUFxQyxDQUFDLG1EQUFtRDtBQUl6Rjs7R0FFRztBQUNILE1BQWEsaUJBQWlCO0lBQzFCLFlBQTZCLEVBQW9CO1FBQXBCLE9BQUUsR0FBRixFQUFFLENBQWtCO0lBQ2pELENBQUM7SUFDTSxJQUFJLENBQUMsS0FBZ0IsRUFBRSxRQUF3QjtRQUNsRCxNQUFNLEdBQUcsR0FBRyxRQUFRLENBQUMsV0FBVyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLGlCQUFpQixFQUFFO1lBQ3JDLFNBQVMsRUFBRSxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQkFBb0IsQ0FBQztZQUN6RCxTQUFTLEVBQUUsR0FBRztZQUNkLHVGQUF1RjtZQUN2RixtQkFBbUI7WUFDbkIsS0FBSztTQUNSLENBQUMsQ0FBQztRQUNILE9BQU8sRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUN4QyxDQUFDO0NBQ0o7QUFkRCw4Q0FjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tIFwiLi4vLi4vYXdzLWlhbVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSdcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tIFwiLi4vLi4vYXdzLWxhbWJkYVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSdcbmltcG9ydCAqIGFzIGxvZ3MgZnJvbSBcIi4uLy4uL2F3cy1sb2dzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtbG9ncydcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuLyoqXG4gKiBVc2UgYSBMYW1kYSBGdW5jdGlvbiBhcyB0aGUgZGVzdGluYXRpb24gZm9yIGEgbG9nIHN1YnNjcmlwdGlvblxuICovXG5leHBvcnQgY2xhc3MgTGFtYmRhRGVzdGluYXRpb24gaW1wbGVtZW50cyBsb2dzLklMb2dTdWJzY3JpcHRpb25EZXN0aW5hdGlvbiB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBmbjogbGFtYmRhLklGdW5jdGlvbikge1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChzY29wZTogQ29uc3RydWN0LCBsb2dHcm91cDogbG9ncy5JTG9nR3JvdXApOiBsb2dzLkxvZ1N1YnNjcmlwdGlvbkRlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICAgICAgY29uc3QgYXJuID0gbG9nR3JvdXAubG9nR3JvdXBBcm47XG4gICAgICAgIHRoaXMuZm4uYWRkUGVybWlzc2lvbignQ2FuSW52b2tlTGFtYmRhJywge1xuICAgICAgICAgICAgcHJpbmNpcGFsOiBuZXcgaWFtLlNlcnZpY2VQcmluY2lwYWwoJ2xvZ3MuYW1hem9uYXdzLmNvbScpLFxuICAgICAgICAgICAgc291cmNlQXJuOiBhcm4sXG4gICAgICAgICAgICAvLyBVc2luZyBTdWJTY3JpcHRpb24gRmlsdGVyIGFzIHNjb3BlIGlzIG9rYXksIHNpbmNlIGV2ZXJ5IFN1YnNjcmlwdGlvbiBGaWx0ZXIgaGFzIG9ubHlcbiAgICAgICAgICAgIC8vIG9uZSBkZXN0aW5hdGlvbi5cbiAgICAgICAgICAgIHNjb3BlLFxuICAgICAgICB9KTtcbiAgICAgICAgcmV0dXJuIHsgYXJuOiB0aGlzLmZuLmZ1bmN0aW9uQXJuIH07XG4gICAgfVxufVxuIl19