"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableFunctionAttribute = void 0;
const appscaling = require("../../../aws-applicationautoscaling"); // Automatically re-written from '@aws-cdk/aws-applicationautoscaling'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * A scalable lambda alias attribute
 */
class ScalableFunctionAttribute extends appscaling.BaseScalableAttribute {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
    /**
     * Scale out or in to keep utilization at a given level. The utilization is tracked by the
     * LambdaProvisionedConcurrencyUtilization metric, emitted by lambda. See:
     * https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics.html#monitoring-metrics-concurrency
     */
    scaleOnUtilization(options) {
        if (!core_1.Token.isUnresolved(options.utilizationTarget) && (options.utilizationTarget < 0.1 || options.utilizationTarget > 0.9)) {
            throw new Error(`Utilization Target should be between 0.1 and 0.9. Found ${options.utilizationTarget}.`);
        }
        super.doScaleToTrackMetric('Tracking', {
            targetValue: options.utilizationTarget,
            predefinedMetric: appscaling.PredefinedMetric.LAMBDA_PROVISIONED_CONCURRENCY_UTILIZATION,
            ...options,
        });
    }
    /**
     * Scale out or in based on schedule.
     */
    scaleOnSchedule(id, action) {
        super.doScaleOnSchedule(id, action);
    }
}
exports.ScalableFunctionAttribute = ScalableFunctionAttribute;
//# sourceMappingURL=data:application/json;base64,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