"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bundle = void 0;
const fs = require("fs");
const path = require("path");
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Produce bundled Lambda asset code
 */
function bundle(options) {
    // Bundling image derived from runtime bundling image (AWS SAM docker image)
    const image = cdk.BundlingDockerImage.fromAsset(__dirname, {
        buildArgs: {
            IMAGE: options.runtime.bundlingDockerImage.image,
        },
    });
    let installer = options.runtime === lambda.Runtime.PYTHON_2_7 ? Installer.PIP : Installer.PIP3;
    let hasRequirements = fs.existsSync(path.join(options.entry, 'requirements.txt'));
    let depsCommand = chain([
        hasRequirements ? `${installer} install -r requirements.txt -t ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}` : '',
        `rsync -r . ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}`,
    ]);
    return lambda.Code.fromAsset(options.entry, {
        bundling: {
            image,
            command: ['bash', '-c', depsCommand],
        },
    });
}
exports.bundle = bundle;
var Installer;
(function (Installer) {
    Installer["PIP"] = "pip";
    Installer["PIP3"] = "pip3";
})(Installer || (Installer = {}));
function chain(commands) {
    return commands.filter(c => !!c).join(' && ');
}
//# sourceMappingURL=data:application/json;base64,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