"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn, _options) {
        // deduplicated automatically
        events.EventBus.grantPutEvents(fn); // Cannot restrict to a specific resource
        return {
            destination: this.eventBus && this.eventBus.eventBusArn || core_1.Stack.of(fn).formatArn({
                service: 'events',
                resource: 'event-bus',
                resourceName: 'default',
            }),
        };
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
//# sourceMappingURL=data:application/json;base64,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