import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::KinesisFirehose::DeliveryStream`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export interface CfnDeliveryStreamProps {
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamname
     */
    readonly deliveryStreamName?: string;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamtype
     */
    readonly deliveryStreamType?: string;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration
     */
    readonly elasticsearchDestinationConfiguration?: CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration
     */
    readonly extendedS3DestinationConfiguration?: CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.HttpEndpointDestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration
     */
    readonly httpEndpointDestinationConfiguration?: CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration
     */
    readonly kinesisStreamSourceConfiguration?: CfnDeliveryStream.KinesisStreamSourceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration
     */
    readonly redshiftDestinationConfiguration?: CfnDeliveryStream.RedshiftDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration
     */
    readonly s3DestinationConfiguration?: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration
     */
    readonly splunkDestinationConfiguration?: CfnDeliveryStream.SplunkDestinationConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`
 *
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare class CfnDeliveryStream extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisFirehose::DeliveryStream";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamname
     */
    deliveryStreamName: string | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamtype
     */
    deliveryStreamType: string | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration
     */
    elasticsearchDestinationConfiguration: CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration
     */
    extendedS3DestinationConfiguration: CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.HttpEndpointDestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration
     */
    httpEndpointDestinationConfiguration: CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration
     */
    kinesisStreamSourceConfiguration: CfnDeliveryStream.KinesisStreamSourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration
     */
    redshiftDestinationConfiguration: CfnDeliveryStream.RedshiftDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration
     */
    s3DestinationConfiguration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration
     */
    splunkDestinationConfiguration: CfnDeliveryStream.SplunkDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::KinesisFirehose::DeliveryStream`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDeliveryStreamProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html
     */
    interface BufferingHintsProperty {
        /**
         * `CfnDeliveryStream.BufferingHintsProperty.IntervalInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-intervalinseconds
         */
        readonly intervalInSeconds?: number;
        /**
         * `CfnDeliveryStream.BufferingHintsProperty.SizeInMBs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-sizeinmbs
         */
        readonly sizeInMBs?: number;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html
     */
    interface CloudWatchLoggingOptionsProperty {
        /**
         * `CfnDeliveryStream.CloudWatchLoggingOptionsProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.CloudWatchLoggingOptionsProperty.LogGroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-loggroupname
         */
        readonly logGroupName?: string;
        /**
         * `CfnDeliveryStream.CloudWatchLoggingOptionsProperty.LogStreamName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-logstreamname
         */
        readonly logStreamName?: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html
     */
    interface CopyCommandProperty {
        /**
         * `CfnDeliveryStream.CopyCommandProperty.CopyOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-copyoptions
         */
        readonly copyOptions?: string;
        /**
         * `CfnDeliveryStream.CopyCommandProperty.DataTableColumns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablecolumns
         */
        readonly dataTableColumns?: string;
        /**
         * `CfnDeliveryStream.CopyCommandProperty.DataTableName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablename
         */
        readonly dataTableName: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html
     */
    interface DataFormatConversionConfigurationProperty {
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.InputFormatConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-inputformatconfiguration
         */
        readonly inputFormatConfiguration?: CfnDeliveryStream.InputFormatConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.OutputFormatConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-outputformatconfiguration
         */
        readonly outputFormatConfiguration?: CfnDeliveryStream.OutputFormatConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.SchemaConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-schemaconfiguration
         */
        readonly schemaConfiguration?: CfnDeliveryStream.SchemaConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html
     */
    interface DeserializerProperty {
        /**
         * `CfnDeliveryStream.DeserializerProperty.HiveJsonSerDe`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-hivejsonserde
         */
        readonly hiveJsonSerDe?: CfnDeliveryStream.HiveJsonSerDeProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DeserializerProperty.OpenXJsonSerDe`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-openxjsonserde
         */
        readonly openXJsonSerDe?: CfnDeliveryStream.OpenXJsonSerDeProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html
     */
    interface ElasticsearchBufferingHintsProperty {
        /**
         * `CfnDeliveryStream.ElasticsearchBufferingHintsProperty.IntervalInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-intervalinseconds
         */
        readonly intervalInSeconds?: number;
        /**
         * `CfnDeliveryStream.ElasticsearchBufferingHintsProperty.SizeInMBs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-sizeinmbs
         */
        readonly sizeInMBs?: number;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html
     */
    interface ElasticsearchDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.BufferingHints`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-bufferinghints
         */
        readonly bufferingHints?: CfnDeliveryStream.ElasticsearchBufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.CloudWatchLoggingOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.ClusterEndpoint`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-clusterendpoint
         */
        readonly clusterEndpoint?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.DomainARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-domainarn
         */
        readonly domainArn?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.IndexName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexname
         */
        readonly indexName: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.IndexRotationPeriod`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexrotationperiod
         */
        readonly indexRotationPeriod?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.ProcessingConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.RetryOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-retryoptions
         */
        readonly retryOptions?: CfnDeliveryStream.ElasticsearchRetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.RoleARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.S3BackupMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.S3Configuration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3configuration
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.TypeName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-typename
         */
        readonly typeName?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.VpcConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-vpcconfiguration
         */
        readonly vpcConfiguration?: CfnDeliveryStream.VpcConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html
     */
    interface ElasticsearchRetryOptionsProperty {
        /**
         * `CfnDeliveryStream.ElasticsearchRetryOptionsProperty.DurationInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html#cfn-kinesisfirehose-deliverystream-elasticsearchretryoptions-durationinseconds
         */
        readonly durationInSeconds?: number;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnDeliveryStream.EncryptionConfigurationProperty.KMSEncryptionConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-kmsencryptionconfig
         */
        readonly kmsEncryptionConfig?: CfnDeliveryStream.KMSEncryptionConfigProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.EncryptionConfigurationProperty.NoEncryptionConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-noencryptionconfig
         */
        readonly noEncryptionConfig?: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html
     */
    interface ExtendedS3DestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.BucketARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bucketarn
         */
        readonly bucketArn: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.BufferingHints`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bufferinghints
         */
        readonly bufferingHints?: CfnDeliveryStream.BufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.CloudWatchLoggingOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.CompressionFormat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-compressionformat
         */
        readonly compressionFormat?: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.DataFormatConversionConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-dataformatconversionconfiguration
         */
        readonly dataFormatConversionConfiguration?: CfnDeliveryStream.DataFormatConversionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.EncryptionConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-encryptionconfiguration
         */
        readonly encryptionConfiguration?: CfnDeliveryStream.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.ErrorOutputPrefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-erroroutputprefix
         */
        readonly errorOutputPrefix?: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.ProcessingConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.RoleARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.S3BackupConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupconfiguration
         */
        readonly s3BackupConfiguration?: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.S3BackupMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html
     */
    interface HiveJsonSerDeProperty {
        /**
         * `CfnDeliveryStream.HiveJsonSerDeProperty.TimestampFormats`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html#cfn-kinesisfirehose-deliverystream-hivejsonserde-timestampformats
         */
        readonly timestampFormats?: string[];
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html
     */
    interface HttpEndpointCommonAttributeProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointCommonAttributeProperty.AttributeName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnDeliveryStream.HttpEndpointCommonAttributeProperty.AttributeValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributevalue
         */
        readonly attributeValue: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html
     */
    interface HttpEndpointConfigurationProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointConfigurationProperty.AccessKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-accesskey
         */
        readonly accessKey?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointConfigurationProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-name
         */
        readonly name?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointConfigurationProperty.Url`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-url
         */
        readonly url: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html
     */
    interface HttpEndpointDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.BufferingHints`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-bufferinghints
         */
        readonly bufferingHints?: CfnDeliveryStream.BufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.CloudWatchLoggingOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.EndpointConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-endpointconfiguration
         */
        readonly endpointConfiguration: CfnDeliveryStream.HttpEndpointConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.ProcessingConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.RequestConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-requestconfiguration
         */
        readonly requestConfiguration?: CfnDeliveryStream.HttpEndpointRequestConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.RetryOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-retryoptions
         */
        readonly retryOptions?: CfnDeliveryStream.RetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.RoleARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.S3BackupMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.S3Configuration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3configuration
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html
     */
    interface HttpEndpointRequestConfigurationProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointRequestConfigurationProperty.CommonAttributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-commonattributes
         */
        readonly commonAttributes?: Array<CfnDeliveryStream.HttpEndpointCommonAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointRequestConfigurationProperty.ContentEncoding`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-contentencoding
         */
        readonly contentEncoding?: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html
     */
    interface InputFormatConfigurationProperty {
        /**
         * `CfnDeliveryStream.InputFormatConfigurationProperty.Deserializer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-inputformatconfiguration-deserializer
         */
        readonly deserializer?: CfnDeliveryStream.DeserializerProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html
     */
    interface KMSEncryptionConfigProperty {
        /**
         * `CfnDeliveryStream.KMSEncryptionConfigProperty.AWSKMSKeyARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html#cfn-kinesisfirehose-deliverystream-kmsencryptionconfig-awskmskeyarn
         */
        readonly awskmsKeyArn: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html
     */
    interface KinesisStreamSourceConfigurationProperty {
        /**
         * `CfnDeliveryStream.KinesisStreamSourceConfigurationProperty.KinesisStreamARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-kinesisstreamarn
         */
        readonly kinesisStreamArn: string;
        /**
         * `CfnDeliveryStream.KinesisStreamSourceConfigurationProperty.RoleARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html
     */
    interface OpenXJsonSerDeProperty {
        /**
         * `CfnDeliveryStream.OpenXJsonSerDeProperty.CaseInsensitive`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-caseinsensitive
         */
        readonly caseInsensitive?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.OpenXJsonSerDeProperty.ColumnToJsonKeyMappings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-columntojsonkeymappings
         */
        readonly columnToJsonKeyMappings?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.OpenXJsonSerDeProperty.ConvertDotsInJsonKeysToUnderscores`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-convertdotsinjsonkeystounderscores
         */
        readonly convertDotsInJsonKeysToUnderscores?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html
     */
    interface OrcSerDeProperty {
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.BlockSizeBytes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-blocksizebytes
         */
        readonly blockSizeBytes?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.BloomFilterColumns`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfiltercolumns
         */
        readonly bloomFilterColumns?: string[];
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.BloomFilterFalsePositiveProbability`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfilterfalsepositiveprobability
         */
        readonly bloomFilterFalsePositiveProbability?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.Compression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression
         */
        readonly compression?: string;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.DictionaryKeyThreshold`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-dictionarykeythreshold
         */
        readonly dictionaryKeyThreshold?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.EnablePadding`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-enablepadding
         */
        readonly enablePadding?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.FormatVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-formatversion
         */
        readonly formatVersion?: string;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.PaddingTolerance`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-paddingtolerance
         */
        readonly paddingTolerance?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.RowIndexStride`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-rowindexstride
         */
        readonly rowIndexStride?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.StripeSizeBytes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-stripesizebytes
         */
        readonly stripeSizeBytes?: number;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html
     */
    interface OutputFormatConfigurationProperty {
        /**
         * `CfnDeliveryStream.OutputFormatConfigurationProperty.Serializer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-outputformatconfiguration-serializer
         */
        readonly serializer?: CfnDeliveryStream.SerializerProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html
     */
    interface ParquetSerDeProperty {
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.BlockSizeBytes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-blocksizebytes
         */
        readonly blockSizeBytes?: number;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.Compression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression
         */
        readonly compression?: string;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.EnableDictionaryCompression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-enabledictionarycompression
         */
        readonly enableDictionaryCompression?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.MaxPaddingBytes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-maxpaddingbytes
         */
        readonly maxPaddingBytes?: number;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.PageSizeBytes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-pagesizebytes
         */
        readonly pageSizeBytes?: number;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.WriterVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-writerversion
         */
        readonly writerVersion?: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html
     */
    interface ProcessingConfigurationProperty {
        /**
         * `CfnDeliveryStream.ProcessingConfigurationProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ProcessingConfigurationProperty.Processors`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-processors
         */
        readonly processors?: Array<CfnDeliveryStream.ProcessorProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html
     */
    interface ProcessorProperty {
        /**
         * `CfnDeliveryStream.ProcessorProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-parameters
         */
        readonly parameters?: Array<CfnDeliveryStream.ProcessorParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ProcessorProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-type
         */
        readonly type: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html
     */
    interface ProcessorParameterProperty {
        /**
         * `CfnDeliveryStream.ProcessorParameterProperty.ParameterName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametername
         */
        readonly parameterName: string;
        /**
         * `CfnDeliveryStream.ProcessorParameterProperty.ParameterValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametervalue
         */
        readonly parameterValue: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html
     */
    interface RedshiftDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.CloudWatchLoggingOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.ClusterJDBCURL`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-clusterjdbcurl
         */
        readonly clusterJdbcurl: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.CopyCommand`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-copycommand
         */
        readonly copyCommand: CfnDeliveryStream.CopyCommandProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.Password`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-password
         */
        readonly password: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.ProcessingConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.RetryOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-retryoptions
         */
        readonly retryOptions?: CfnDeliveryStream.RedshiftRetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.RoleARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.S3BackupConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupconfiguration
         */
        readonly s3BackupConfiguration?: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.S3BackupMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.S3Configuration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3configuration
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-username
         */
        readonly username: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html
     */
    interface RedshiftRetryOptionsProperty {
        /**
         * `CfnDeliveryStream.RedshiftRetryOptionsProperty.DurationInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html#cfn-kinesisfirehose-deliverystream-redshiftretryoptions-durationinseconds
         */
        readonly durationInSeconds?: number;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html
     */
    interface RetryOptionsProperty {
        /**
         * `CfnDeliveryStream.RetryOptionsProperty.DurationInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html#cfn-kinesisfirehose-deliverystream-retryoptions-durationinseconds
         */
        readonly durationInSeconds?: number;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html
     */
    interface S3DestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.BucketARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bucketarn
         */
        readonly bucketArn: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.BufferingHints`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bufferinghints
         */
        readonly bufferingHints?: CfnDeliveryStream.BufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.CloudWatchLoggingOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.CompressionFormat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-compressionformat
         */
        readonly compressionFormat?: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.EncryptionConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-encryptionconfiguration
         */
        readonly encryptionConfiguration?: CfnDeliveryStream.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.ErrorOutputPrefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-erroroutputprefix
         */
        readonly errorOutputPrefix?: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.Prefix`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.RoleARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html
     */
    interface SchemaConfigurationProperty {
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.CatalogId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-catalogid
         */
        readonly catalogId?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.DatabaseName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-databasename
         */
        readonly databaseName?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.Region`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-region
         */
        readonly region?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.RoleARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.TableName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-tablename
         */
        readonly tableName?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.VersionId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-versionid
         */
        readonly versionId?: string;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html
     */
    interface SerializerProperty {
        /**
         * `CfnDeliveryStream.SerializerProperty.OrcSerDe`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-orcserde
         */
        readonly orcSerDe?: CfnDeliveryStream.OrcSerDeProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SerializerProperty.ParquetSerDe`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-parquetserde
         */
        readonly parquetSerDe?: CfnDeliveryStream.ParquetSerDeProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html
     */
    interface SplunkDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.CloudWatchLoggingOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECAcknowledgmentTimeoutInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hecacknowledgmenttimeoutinseconds
         */
        readonly hecAcknowledgmentTimeoutInSeconds?: number;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECEndpoint`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hecendpoint
         */
        readonly hecEndpoint: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECEndpointType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hecendpointtype
         */
        readonly hecEndpointType: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECToken`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hectoken
         */
        readonly hecToken: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.ProcessingConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.RetryOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-retryoptions
         */
        readonly retryOptions?: CfnDeliveryStream.SplunkRetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.S3BackupMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.S3Configuration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-s3configuration
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkretryoptions.html
     */
    interface SplunkRetryOptionsProperty {
        /**
         * `CfnDeliveryStream.SplunkRetryOptionsProperty.DurationInSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkretryoptions.html#cfn-kinesisfirehose-deliverystream-splunkretryoptions-durationinseconds
         */
        readonly durationInSeconds?: number;
    }
}
export declare namespace CfnDeliveryStream {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html
     */
    interface VpcConfigurationProperty {
        /**
         * `CfnDeliveryStream.VpcConfigurationProperty.RoleARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html#cfn-kinesisfirehose-deliverystream-vpcconfiguration-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.VpcConfigurationProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html#cfn-kinesisfirehose-deliverystream-vpcconfiguration-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnDeliveryStream.VpcConfigurationProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html#cfn-kinesisfirehose-deliverystream-vpcconfiguration-subnetids
         */
        readonly subnetIds: string[];
    }
}
