import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::IoT1Click::Device`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html
 */
export interface CfnDeviceProps {
    /**
     * `AWS::IoT1Click::Device.DeviceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html#cfn-iot1click-device-deviceid
     */
    readonly deviceId: string;
    /**
     * `AWS::IoT1Click::Device.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html#cfn-iot1click-device-enabled
     */
    readonly enabled: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::IoT1Click::Device`
 *
 * @cloudformationResource AWS::IoT1Click::Device
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html
 */
export declare class CfnDevice extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT1Click::Device";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute DeviceId
     */
    readonly attrDeviceId: string;
    /**
     * @cloudformationAttribute Enabled
     */
    readonly attrEnabled: cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Device.DeviceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html#cfn-iot1click-device-deviceid
     */
    deviceId: string;
    /**
     * `AWS::IoT1Click::Device.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-device.html#cfn-iot1click-device-enabled
     */
    enabled: boolean | cdk.IResolvable;
    /**
     * Create a new `AWS::IoT1Click::Device`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeviceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT1Click::Placement`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html
 */
export interface CfnPlacementProps {
    /**
     * `AWS::IoT1Click::Placement.ProjectName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-projectname
     */
    readonly projectName: string;
    /**
     * `AWS::IoT1Click::Placement.AssociatedDevices`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-associateddevices
     */
    readonly associatedDevices?: any | cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Placement.Attributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-attributes
     */
    readonly attributes?: any | cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Placement.PlacementName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-placementname
     */
    readonly placementName?: string;
}
/**
 * A CloudFormation `AWS::IoT1Click::Placement`
 *
 * @cloudformationResource AWS::IoT1Click::Placement
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html
 */
export declare class CfnPlacement extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT1Click::Placement";
    /**
     * @cloudformationAttribute PlacementName
     */
    readonly attrPlacementName: string;
    /**
     * @cloudformationAttribute ProjectName
     */
    readonly attrProjectName: string;
    /**
     * `AWS::IoT1Click::Placement.ProjectName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-projectname
     */
    projectName: string;
    /**
     * `AWS::IoT1Click::Placement.AssociatedDevices`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-associateddevices
     */
    associatedDevices: any | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT1Click::Placement.Attributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-attributes
     */
    attributes: any | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT1Click::Placement.PlacementName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-placement.html#cfn-iot1click-placement-placementname
     */
    placementName: string | undefined;
    /**
     * Create a new `AWS::IoT1Click::Placement`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPlacementProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoT1Click::Project`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html
 */
export interface CfnProjectProps {
    /**
     * `AWS::IoT1Click::Project.PlacementTemplate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-placementtemplate
     */
    readonly placementTemplate: CfnProject.PlacementTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Project.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-description
     */
    readonly description?: string;
    /**
     * `AWS::IoT1Click::Project.ProjectName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-projectname
     */
    readonly projectName?: string;
}
/**
 * A CloudFormation `AWS::IoT1Click::Project`
 *
 * @cloudformationResource AWS::IoT1Click::Project
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html
 */
export declare class CfnProject extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT1Click::Project";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute ProjectName
     */
    readonly attrProjectName: string;
    /**
     * `AWS::IoT1Click::Project.PlacementTemplate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-placementtemplate
     */
    placementTemplate: CfnProject.PlacementTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::IoT1Click::Project.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-description
     */
    description: string | undefined;
    /**
     * `AWS::IoT1Click::Project.ProjectName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot1click-project.html#cfn-iot1click-project-projectname
     */
    projectName: string | undefined;
    /**
     * Create a new `AWS::IoT1Click::Project`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProjectProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-devicetemplate.html
     */
    interface DeviceTemplateProperty {
        /**
         * `CfnProject.DeviceTemplateProperty.CallbackOverrides`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-devicetemplate.html#cfn-iot1click-project-devicetemplate-callbackoverrides
         */
        readonly callbackOverrides?: any | cdk.IResolvable;
        /**
         * `CfnProject.DeviceTemplateProperty.DeviceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-devicetemplate.html#cfn-iot1click-project-devicetemplate-devicetype
         */
        readonly deviceType?: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-placementtemplate.html
     */
    interface PlacementTemplateProperty {
        /**
         * `CfnProject.PlacementTemplateProperty.DefaultAttributes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-placementtemplate.html#cfn-iot1click-project-placementtemplate-defaultattributes
         */
        readonly defaultAttributes?: any | cdk.IResolvable;
        /**
         * `CfnProject.PlacementTemplateProperty.DeviceTemplates`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot1click-project-placementtemplate.html#cfn-iot1click-project-placementtemplate-devicetemplates
         */
        readonly deviceTemplates?: {
            [key: string]: (CfnProject.DeviceTemplateProperty | cdk.IResolvable);
        } | cdk.IResolvable;
    }
}
