"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.external = void 0;
/* istanbul ignore file */
const tls = require("tls");
const url = require("url");
// eslint-disable-next-line import/no-extraneous-dependencies
const aws = require("aws-sdk");
let client;
function iam() {
    if (!client) {
        client = new aws.IAM();
    }
    return client;
}
function defaultLogger(fmt, ...args) {
    // eslint-disable-next-line no-console
    console.log(fmt, ...args);
}
/**
 * Downloads the CA thumbprint from the issuer URL
 */
async function downloadThumbprint(issuerUrl) {
    exports.external.log(`downloading certificate authority thumbprint for ${issuerUrl}`);
    return new Promise((ok, ko) => {
        const purl = url.parse(issuerUrl);
        const port = purl.port ? parseInt(purl.port, 10) : 443;
        if (!purl.host) {
            return ko(new Error(`unable to determine host from issuer url ${issuerUrl}`));
        }
        const socket = tls.connect(port, purl.host, { rejectUnauthorized: false });
        socket.once('error', ko);
        socket.once('secureConnect', () => {
            const cert = socket.getPeerCertificate();
            socket.end();
            const thumbprint = cert.fingerprint.split(':').join('');
            exports.external.log(`certificate authority thumbprint for ${issuerUrl} is ${thumbprint}`);
            ok(thumbprint);
        });
    });
}
// allows unit test to replace with mocks
/* eslint-disable max-len */
exports.external = {
    downloadThumbprint,
    log: defaultLogger,
    createOpenIDConnectProvider: (req) => iam().createOpenIDConnectProvider(req).promise(),
    deleteOpenIDConnectProvider: (req) => iam().deleteOpenIDConnectProvider(req).promise(),
    updateOpenIDConnectProviderThumbprint: (req) => iam().updateOpenIDConnectProviderThumbprint(req).promise(),
    addClientIDToOpenIDConnectProvider: (req) => iam().addClientIDToOpenIDConnectProvider(req).promise(),
    removeClientIDFromOpenIDConnectProvider: (req) => iam().removeClientIDFromOpenIDConnectProvider(req).promise(),
};
//# sourceMappingURL=data:application/json;base64,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