import * as cdk from "../../core";
import { IAccelerator } from './accelerator';
/**
 * Interface of the Listener
 */
export interface IListener extends cdk.IResource {
    /**
     * The ARN of the listener
     *
     * @attribute
     */
    readonly listenerArn: string;
}
/**
 * construct properties for Listener
 */
export interface ListenerProps {
    /**
     * Name of the listener
     *
     * @default - logical ID of the resource
     */
    readonly listenerName?: string;
    /**
     * The accelerator for this listener
     */
    readonly accelerator: IAccelerator;
    /**
     * The list of port ranges for the connections from clients to the accelerator
     */
    readonly portRanges: PortRange[];
    /**
     * The protocol for the connections from clients to the accelerator
     *
     * @default TCP
     */
    readonly protocol?: ConnectionProtocol;
    /**
     * Client affinity to direct all requests from a user to the same endpoint
     *
     * @default NONE
     */
    readonly clientAffinity?: ClientAffinity;
}
/**
 * The list of port ranges for the connections from clients to the accelerator.
 */
export interface PortRange {
    /**
     * The first port in the range of ports, inclusive.
     */
    readonly fromPort: number;
    /**
     * The last port in the range of ports, inclusive.
     */
    readonly toPort: number;
}
/**
 * The protocol for the connections from clients to the accelerator.
 */
export declare enum ConnectionProtocol {
    /**
     * TCP
     */
    TCP = "TCP",
    /**
     * UDP
     */
    UDP = "UDP"
}
/**
 * Client affinity lets you direct all requests from a user to the same endpoint, if you have stateful applications,
 * regardless of the port and protocol of the client request. Client affinity gives you control over whether to always
 * route each client to the same specific endpoint. If you want a given client to always be routed to the same
 * endpoint, set client affinity to SOURCE_IP.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 */
export declare enum ClientAffinity {
    /**
     * default affinity
     */
    NONE = "NONE",
    /**
     * affinity by source IP
     */
    SOURCE_IP = "SOURCE_IP"
}
/**
 * The construct for the Listener
 */
export declare class Listener extends cdk.Resource implements IListener {
    /**
     * import from ARN
     */
    static fromListenerArn(scope: cdk.Construct, id: string, listenerArn: string): IListener;
    readonly listenerArn: string;
    /**
     * The name of the listener
     *
     * @attribute
     */
    readonly listenerName: string;
    constructor(scope: cdk.Construct, id: string, props: ListenerProps);
}
