"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchJob = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const util_1 = require("./util");
/**
 * Use an AWS Batch Job / Queue as an event rule target.
 * @experimental
 */
class BatchJob {
    constructor(jobQueue, jobDefinition, props = {}) {
        this.jobQueue = jobQueue;
        this.jobDefinition = jobDefinition;
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger queue this batch job as a
     * result from an EventBridge event.
     */
    bind(rule, _id) {
        var _a;
        const batchParameters = {
            jobDefinition: this.jobDefinition.jobDefinitionArn,
            jobName: (_a = this.props.jobName) !== null && _a !== void 0 ? _a : rule.node.uniqueId,
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        return {
            id: '',
            arn: this.jobQueue.jobQueueArn,
            // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
            // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
            role: util_1.singletonEventRole(this.jobDefinition, [
                new iam.PolicyStatement({
                    actions: ['batch:SubmitJob'],
                    resources: [
                        this.jobDefinition.jobDefinitionArn,
                        this.jobQueue.jobQueueArn,
                    ],
                }),
            ]),
            input: this.props.event,
            targetResource: this.jobQueue,
            batchParameters,
        };
    }
}
exports.BatchJob = BatchJob;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmF0Y2guanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJiYXRjaC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQSxxQ0FBcUMsQ0FBQyxtREFBbUQ7QUFDekYsaUNBQTRDO0FBbUM1Qzs7O0dBR0c7QUFDSCxNQUFhLFFBQVE7SUFDakIsWUFBNkIsUUFBeUIsRUFBbUIsYUFBbUMsRUFBbUIsUUFBdUIsRUFBRTtRQUEzSCxhQUFRLEdBQVIsUUFBUSxDQUFpQjtRQUFtQixrQkFBYSxHQUFiLGFBQWEsQ0FBc0I7UUFBbUIsVUFBSyxHQUFMLEtBQUssQ0FBb0I7SUFBSSxDQUFDO0lBQzdKOzs7T0FHRztJQUNJLElBQUksQ0FBQyxJQUFrQixFQUFFLEdBQVk7O1FBQ3hDLE1BQU0sZUFBZSxHQUEyQztZQUM1RCxhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0I7WUFDbEQsT0FBTyxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxtQ0FBSSxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVE7WUFDakQsZUFBZSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ3hFLGFBQWEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsRUFBRSxRQUFRLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDLENBQUMsU0FBUztTQUNyRixDQUFDO1FBQ0YsT0FBTztZQUNILEVBQUUsRUFBRSxFQUFFO1lBQ04sR0FBRyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVztZQUM5Qiw0SEFBNEg7WUFDNUgsNkdBQTZHO1lBQzdHLElBQUksRUFBRSx5QkFBa0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxFQUFFO2dCQUN6QyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7b0JBQ3BCLE9BQU8sRUFBRSxDQUFDLGlCQUFpQixDQUFDO29CQUM1QixTQUFTLEVBQUU7d0JBQ1AsSUFBSSxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0I7d0JBQ25DLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVztxQkFDNUI7aUJBQ0osQ0FBQzthQUNMLENBQUM7WUFDRixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLO1lBQ3ZCLGNBQWMsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUM3QixlQUFlO1NBQ2xCLENBQUM7SUFDTixDQUFDO0NBQ0o7QUFoQ0QsNEJBZ0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYmF0Y2ggZnJvbSBcIi4uLy4uL2F3cy1iYXRjaFwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWJhdGNoJ1xuaW1wb3J0ICogYXMgZXZlbnRzIGZyb20gXCIuLi8uLi9hd3MtZXZlbnRzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtZXZlbnRzJ1xuaW1wb3J0ICogYXMgaWFtIGZyb20gXCIuLi8uLi9hd3MtaWFtXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtaWFtJ1xuaW1wb3J0IHsgc2luZ2xldG9uRXZlbnRSb2xlIH0gZnJvbSAnLi91dGlsJztcbi8qKlxuICogQ3VzdG9taXplIHRoZSBCYXRjaCBKb2IgRXZlbnQgVGFyZ2V0XG4gKiBAZXhwZXJpbWVudGFsXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQmF0Y2hKb2JQcm9wcyB7XG4gICAgLyoqXG4gICAgICogVGhlIGV2ZW50IHRvIHNlbmQgdG8gdGhlIExhbWJkYVxuICAgICAqXG4gICAgICogVGhpcyB3aWxsIGJlIHRoZSBwYXlsb2FkIHNlbnQgdG8gdGhlIExhbWJkYSBGdW5jdGlvbi5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IHRoZSBlbnRpcmUgRXZlbnRCcmlkZ2UgZXZlbnRcbiAgICAgKi9cbiAgICByZWFkb25seSBldmVudD86IGV2ZW50cy5SdWxlVGFyZ2V0SW5wdXQ7XG4gICAgLyoqXG4gICAgICogVGhlIHNpemUgb2YgdGhlIGFycmF5LCBpZiB0aGlzIGlzIGFuIGFycmF5IGJhdGNoIGpvYi5cbiAgICAgKlxuICAgICAqIFZhbGlkIHZhbHVlcyBhcmUgaW50ZWdlcnMgYmV0d2VlbiAyIGFuZCAxMCwwMDAuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBubyBhcnJheVByb3BlcnRpZXMgYXJlIHNldFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNpemU/OiBudW1iZXI7XG4gICAgLyoqXG4gICAgICogVGhlIG51bWJlciBvZiB0aW1lcyB0byBhdHRlbXB0IHRvIHJldHJ5LCBpZiB0aGUgam9iIGZhaWxzLiBWYWxpZCB2YWx1ZXMgYXJlIDHigJMxMC5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IG5vIHJldHJ5U3RyYXRlZ3kgaXMgc2V0XG4gICAgICovXG4gICAgcmVhZG9ubHkgYXR0ZW1wdHM/OiBudW1iZXI7XG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIHN1Ym1pdHRlZCBqb2JcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gQXV0b21hdGljYWxseSBnZW5lcmF0ZWRcbiAgICAgKi9cbiAgICByZWFkb25seSBqb2JOYW1lPzogc3RyaW5nO1xufVxuLyoqXG4gKiBVc2UgYW4gQVdTIEJhdGNoIEpvYiAvIFF1ZXVlIGFzIGFuIGV2ZW50IHJ1bGUgdGFyZ2V0LlxuICogQGV4cGVyaW1lbnRhbFxuICovXG5leHBvcnQgY2xhc3MgQmF0Y2hKb2IgaW1wbGVtZW50cyBldmVudHMuSVJ1bGVUYXJnZXQge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgam9iUXVldWU6IGJhdGNoLklKb2JRdWV1ZSwgcHJpdmF0ZSByZWFkb25seSBqb2JEZWZpbml0aW9uOiBiYXRjaC5JSm9iRGVmaW5pdGlvbiwgcHJpdmF0ZSByZWFkb25seSBwcm9wczogQmF0Y2hKb2JQcm9wcyA9IHt9KSB7IH1cbiAgICAvKipcbiAgICAgKiBSZXR1cm5zIGEgUnVsZVRhcmdldCB0aGF0IGNhbiBiZSB1c2VkIHRvIHRyaWdnZXIgcXVldWUgdGhpcyBiYXRjaCBqb2IgYXMgYVxuICAgICAqIHJlc3VsdCBmcm9tIGFuIEV2ZW50QnJpZGdlIGV2ZW50LlxuICAgICAqL1xuICAgIHB1YmxpYyBiaW5kKHJ1bGU6IGV2ZW50cy5JUnVsZSwgX2lkPzogc3RyaW5nKTogZXZlbnRzLlJ1bGVUYXJnZXRDb25maWcge1xuICAgICAgICBjb25zdCBiYXRjaFBhcmFtZXRlcnM6IGV2ZW50cy5DZm5SdWxlLkJhdGNoUGFyYW1ldGVyc1Byb3BlcnR5ID0ge1xuICAgICAgICAgICAgam9iRGVmaW5pdGlvbjogdGhpcy5qb2JEZWZpbml0aW9uLmpvYkRlZmluaXRpb25Bcm4sXG4gICAgICAgICAgICBqb2JOYW1lOiB0aGlzLnByb3BzLmpvYk5hbWUgPz8gcnVsZS5ub2RlLnVuaXF1ZUlkLFxuICAgICAgICAgICAgYXJyYXlQcm9wZXJ0aWVzOiB0aGlzLnByb3BzLnNpemUgPyB7IHNpemU6IHRoaXMucHJvcHMuc2l6ZSB9IDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgcmV0cnlTdHJhdGVneTogdGhpcy5wcm9wcy5hdHRlbXB0cyA/IHsgYXR0ZW1wdHM6IHRoaXMucHJvcHMuYXR0ZW1wdHMgfSA6IHVuZGVmaW5lZCxcbiAgICAgICAgfTtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGlkOiAnJyxcbiAgICAgICAgICAgIGFybjogdGhpcy5qb2JRdWV1ZS5qb2JRdWV1ZUFybixcbiAgICAgICAgICAgIC8vIFdoZW4gc2NvcGluZyByZXNvdXJjZS1sZXZlbCBhY2Nlc3MgZm9yIGpvYiBzdWJtaXNzaW9uLCB5b3UgbXVzdCBwcm92aWRlIGJvdGggam9iIHF1ZXVlIGFuZCBqb2IgZGVmaW5pdGlvbiByZXNvdXJjZSB0eXBlcy5cbiAgICAgICAgICAgIC8vIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9iYXRjaC9sYXRlc3QvdXNlcmd1aWRlL0V4YW1wbGVQb2xpY2llc19CQVRDSC5odG1sI2lhbS1leGFtcGxlLXJlc3RyaWN0LWpvYi1kZWZcbiAgICAgICAgICAgIHJvbGU6IHNpbmdsZXRvbkV2ZW50Um9sZSh0aGlzLmpvYkRlZmluaXRpb24sIFtcbiAgICAgICAgICAgICAgICBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgICAgICAgICAgICAgIGFjdGlvbnM6IFsnYmF0Y2g6U3VibWl0Sm9iJ10sXG4gICAgICAgICAgICAgICAgICAgIHJlc291cmNlczogW1xuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5qb2JEZWZpbml0aW9uLmpvYkRlZmluaXRpb25Bcm4sXG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLmpvYlF1ZXVlLmpvYlF1ZXVlQXJuLFxuICAgICAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgXSksXG4gICAgICAgICAgICBpbnB1dDogdGhpcy5wcm9wcy5ldmVudCxcbiAgICAgICAgICAgIHRhcmdldFJlc291cmNlOiB0aGlzLmpvYlF1ZXVlLFxuICAgICAgICAgICAgYmF0Y2hQYXJhbWV0ZXJzLFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==