"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceTarget = exports.InstanceIdTarget = void 0;
const elbv2 = require("../../aws-elasticloadbalancingv2"); // Automatically re-written from '@aws-cdk/aws-elasticloadbalancingv2'
/**
 * An EC2 instance that is the target for load balancing
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 */
class InstanceIdTarget {
    /**
     * Create a new Instance target
     *
     * @param instanceId Instance ID of the instance to register to
     * @param port Override the default port for the target group
     */
    constructor(instanceId, port) {
        this.instanceId = instanceId;
        this.port = port;
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * Register this instance target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.INSTANCE,
            targetJson: { id: this.instanceId, port: this.port },
        };
    }
}
exports.InstanceIdTarget = InstanceIdTarget;
class InstanceTarget extends InstanceIdTarget {
    /**
     * Create a new Instance target
     *
     * @param instance Instance to register to
     * @param port Override the default port for the target group
     */
    constructor(instance, port) {
        super(instance.instanceId, port);
    }
}
exports.InstanceTarget = InstanceTarget;
//# sourceMappingURL=data:application/json;base64,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