"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFileLogDriver = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to json-file Logs.
 */
class JsonFileLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the JsonFileLogDriver class.
     *
     * @param props the json-file log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        // Validation
        if (props.maxFile && props.maxFile < 0) {
            throw new Error('`maxFile` must be a positive integer.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'json-file',
            options: utils_1.stringifyOptions({
                'max-size': this.props.maxSize,
                'max-file': this.props.maxFile,
                'compress': this.props.compress,
                'labels': utils_1.joinWithCommas(this.props.labels),
                'env': utils_1.joinWithCommas(this.props.env),
                'env-regex': this.props.envRegex,
            }),
        };
    }
}
exports.JsonFileLogDriver = JsonFileLogDriver;
//# sourceMappingURL=data:application/json;base64,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