"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLogDriver = void 0;
const logs = require("../../../aws-logs"); // Automatically re-written from '@aws-cdk/aws-logs'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to CloudWatch Logs.
 */
class AwsLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the AwsLogDriver class.
     *
     * @param props the awslogs log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.logGroup && props.logRetention) {
            throw new Error('Cannot specify both `logGroup` and `logRetentionDays`.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(scope, containerDefinition) {
        this.logGroup = this.props.logGroup || new logs.LogGroup(scope, 'LogGroup', {
            retention: this.props.logRetention || Infinity,
        });
        this.logGroup.grantWrite(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            logDriver: 'awslogs',
            options: utils_1.removeEmpty({
                'awslogs-group': this.logGroup.logGroupName,
                'awslogs-stream-prefix': this.props.streamPrefix,
                'awslogs-region': core_1.Stack.of(containerDefinition).region,
                'awslogs-datetime-format': this.props.datetimeFormat,
                'awslogs-multiline-pattern': this.props.multilinePattern,
            }),
        };
    }
}
exports.AwsLogDriver = AwsLogDriver;
//# sourceMappingURL=data:application/json;base64,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