"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateTaskDefinition = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on a Fargate cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class FargateTaskDefinition extends task_definition_1.TaskDefinition {
    // NOTE: Until the fix to https://github.com/Microsoft/TypeScript/issues/26969 gets released,
    // we need to explicitly write the type here, as type deduction for enums won't lead to
    // the import being generated in the .d.ts file.
    /**
     * Constructs a new instance of the FargateTaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            cpu: props.cpu !== undefined ? core_1.Tokenization.stringifyNumber(props.cpu) : '256',
            memoryMiB: props.memoryLimitMiB !== undefined ? core_1.Tokenization.stringifyNumber(props.memoryLimitMiB) : '512',
            compatibility: task_definition_1.Compatibility.FARGATE,
            networkMode: task_definition_1.NetworkMode.AWS_VPC,
        });
        /**
         * The Docker networking mode to use for the containers in the task. Fargate tasks require the awsvpc network mode.
         */
        this.networkMode = task_definition_1.NetworkMode.AWS_VPC;
    }
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromFargateTaskDefinitionArn(scope, id, fargateTaskDefinitionArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.taskDefinitionArn = fargateTaskDefinitionArn;
                this.compatibility = task_definition_1.Compatibility.FARGATE;
                this.isEc2Compatible = false;
                this.isFargateCompatible = true;
            }
        }
        return new Import(scope, id);
    }
}
exports.FargateTaskDefinition = FargateTaskDefinition;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmFyZ2F0ZS10YXNrLWRlZmluaXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmYXJnYXRlLXRhc2stZGVmaW5pdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBa0UsQ0FBQyxnREFBZ0Q7QUFDbkgsNkRBQWlJO0FBc0NqSTs7OztHQUlHO0FBQ0gsTUFBYSxxQkFBc0IsU0FBUSxnQ0FBYztJQWlCckQsNkZBQTZGO0lBQzdGLHVGQUF1RjtJQUN2RixnREFBZ0Q7SUFDaEQ7O09BRUc7SUFDSCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQW9DLEVBQUU7UUFDNUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDYixHQUFHLEtBQUs7WUFDUixHQUFHLEVBQUUsS0FBSyxDQUFDLEdBQUcsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLG1CQUFZLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSztZQUM5RSxTQUFTLEVBQUUsS0FBSyxDQUFDLGNBQWMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLG1CQUFZLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSztZQUMxRyxhQUFhLEVBQUUsK0JBQWEsQ0FBQyxPQUFPO1lBQ3BDLFdBQVcsRUFBRSw2QkFBVyxDQUFDLE9BQU87U0FDbkMsQ0FBQyxDQUFDO1FBakJQOztXQUVHO1FBQ2EsZ0JBQVcsR0FBZ0IsNkJBQVcsQ0FBQyxPQUFPLENBQUM7SUFlL0QsQ0FBQztJQTlCRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSx3QkFBZ0M7UUFDckcsTUFBTSxNQUFPLFNBQVEsZUFBUTtZQUE3Qjs7Z0JBQ29CLHNCQUFpQixHQUFHLHdCQUF3QixDQUFDO2dCQUM3QyxrQkFBYSxHQUFHLCtCQUFhLENBQUMsT0FBTyxDQUFDO2dCQUN0QyxvQkFBZSxHQUFHLEtBQUssQ0FBQztnQkFDeEIsd0JBQW1CLEdBQUcsSUFBSSxDQUFDO1lBQy9DLENBQUM7U0FBQTtRQUNELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7Q0FvQko7QUFoQ0Qsc0RBZ0NDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0LCBSZXNvdXJjZSwgVG9rZW5pemF0aW9uIH0gZnJvbSBcIi4uLy4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBDb21tb25UYXNrRGVmaW5pdGlvblByb3BzLCBDb21wYXRpYmlsaXR5LCBJVGFza0RlZmluaXRpb24sIE5ldHdvcmtNb2RlLCBUYXNrRGVmaW5pdGlvbiB9IGZyb20gJy4uL2Jhc2UvdGFzay1kZWZpbml0aW9uJztcbi8qKlxuICogVGhlIHByb3BlcnRpZXMgZm9yIGEgdGFzayBkZWZpbml0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEZhcmdhdGVUYXNrRGVmaW5pdGlvblByb3BzIGV4dGVuZHMgQ29tbW9uVGFza0RlZmluaXRpb25Qcm9wcyB7XG4gICAgLyoqXG4gICAgICogVGhlIG51bWJlciBvZiBjcHUgdW5pdHMgdXNlZCBieSB0aGUgdGFzay4gRm9yIHRhc2tzIHVzaW5nIHRoZSBGYXJnYXRlIGxhdW5jaCB0eXBlLFxuICAgICAqIHRoaXMgZmllbGQgaXMgcmVxdWlyZWQgYW5kIHlvdSBtdXN0IHVzZSBvbmUgb2YgdGhlIGZvbGxvd2luZyB2YWx1ZXMsXG4gICAgICogd2hpY2ggZGV0ZXJtaW5lcyB5b3VyIHJhbmdlIG9mIHZhbGlkIHZhbHVlcyBmb3IgdGhlIG1lbW9yeSBwYXJhbWV0ZXI6XG4gICAgICpcbiAgICAgKiAyNTYgKC4yNSB2Q1BVKSAtIEF2YWlsYWJsZSBtZW1vcnkgdmFsdWVzOiA1MTIgKDAuNSBHQiksIDEwMjQgKDEgR0IpLCAyMDQ4ICgyIEdCKVxuICAgICAqIDUxMiAoLjUgdkNQVSkgLSBBdmFpbGFibGUgbWVtb3J5IHZhbHVlczogMTAyNCAoMSBHQiksIDIwNDggKDIgR0IpLCAzMDcyICgzIEdCKSwgNDA5NiAoNCBHQilcbiAgICAgKiAxMDI0ICgxIHZDUFUpIC0gQXZhaWxhYmxlIG1lbW9yeSB2YWx1ZXM6IDIwNDggKDIgR0IpLCAzMDcyICgzIEdCKSwgNDA5NiAoNCBHQiksIDUxMjAgKDUgR0IpLCA2MTQ0ICg2IEdCKSwgNzE2OCAoNyBHQiksIDgxOTIgKDggR0IpXG4gICAgICogMjA0OCAoMiB2Q1BVKSAtIEF2YWlsYWJsZSBtZW1vcnkgdmFsdWVzOiBCZXR3ZWVuIDQwOTYgKDQgR0IpIGFuZCAxNjM4NCAoMTYgR0IpIGluIGluY3JlbWVudHMgb2YgMTAyNCAoMSBHQilcbiAgICAgKiA0MDk2ICg0IHZDUFUpIC0gQXZhaWxhYmxlIG1lbW9yeSB2YWx1ZXM6IEJldHdlZW4gODE5MiAoOCBHQikgYW5kIDMwNzIwICgzMCBHQikgaW4gaW5jcmVtZW50cyBvZiAxMDI0ICgxIEdCKVxuICAgICAqXG4gICAgICogQGRlZmF1bHQgMjU2XG4gICAgICovXG4gICAgcmVhZG9ubHkgY3B1PzogbnVtYmVyO1xuICAgIC8qKlxuICAgICAqIFRoZSBhbW91bnQgKGluIE1pQikgb2YgbWVtb3J5IHVzZWQgYnkgdGhlIHRhc2suIEZvciB0YXNrcyB1c2luZyB0aGUgRmFyZ2F0ZSBsYXVuY2ggdHlwZSxcbiAgICAgKiB0aGlzIGZpZWxkIGlzIHJlcXVpcmVkIGFuZCB5b3UgbXVzdCB1c2Ugb25lIG9mIHRoZSBmb2xsb3dpbmcgdmFsdWVzLCB3aGljaCBkZXRlcm1pbmVzIHlvdXIgcmFuZ2Ugb2YgdmFsaWQgdmFsdWVzIGZvciB0aGUgY3B1IHBhcmFtZXRlcjpcbiAgICAgKlxuICAgICAqIDUxMiAoMC41IEdCKSwgMTAyNCAoMSBHQiksIDIwNDggKDIgR0IpIC0gQXZhaWxhYmxlIGNwdSB2YWx1ZXM6IDI1NiAoLjI1IHZDUFUpXG4gICAgICogMTAyNCAoMSBHQiksIDIwNDggKDIgR0IpLCAzMDcyICgzIEdCKSwgNDA5NiAoNCBHQikgLSBBdmFpbGFibGUgY3B1IHZhbHVlczogNTEyICguNSB2Q1BVKVxuICAgICAqIDIwNDggKDIgR0IpLCAzMDcyICgzIEdCKSwgNDA5NiAoNCBHQiksIDUxMjAgKDUgR0IpLCA2MTQ0ICg2IEdCKSwgNzE2OCAoNyBHQiksIDgxOTIgKDggR0IpIC0gQXZhaWxhYmxlIGNwdSB2YWx1ZXM6IDEwMjQgKDEgdkNQVSlcbiAgICAgKiBCZXR3ZWVuIDQwOTYgKDQgR0IpIGFuZCAxNjM4NCAoMTYgR0IpIGluIGluY3JlbWVudHMgb2YgMTAyNCAoMSBHQikgLSBBdmFpbGFibGUgY3B1IHZhbHVlczogMjA0OCAoMiB2Q1BVKVxuICAgICAqIEJldHdlZW4gODE5MiAoOCBHQikgYW5kIDMwNzIwICgzMCBHQikgaW4gaW5jcmVtZW50cyBvZiAxMDI0ICgxIEdCKSAtIEF2YWlsYWJsZSBjcHUgdmFsdWVzOiA0MDk2ICg0IHZDUFUpXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCA1MTJcbiAgICAgKi9cbiAgICByZWFkb25seSBtZW1vcnlMaW1pdE1pQj86IG51bWJlcjtcbn1cbi8qKlxuICogVGhlIGludGVyZmFjZSBvZiBhIHRhc2sgZGVmaW5pdGlvbiBydW4gb24gYSBGYXJnYXRlIGNsdXN0ZXIuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUZhcmdhdGVUYXNrRGVmaW5pdGlvbiBleHRlbmRzIElUYXNrRGVmaW5pdGlvbiB7XG59XG4vKipcbiAqIFRoZSBkZXRhaWxzIG9mIGEgdGFzayBkZWZpbml0aW9uIHJ1biBvbiBhIEZhcmdhdGUgY2x1c3Rlci5cbiAqXG4gKiBAcmVzb3VyY2UgQVdTOjpFQ1M6OlRhc2tEZWZpbml0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBGYXJnYXRlVGFza0RlZmluaXRpb24gZXh0ZW5kcyBUYXNrRGVmaW5pdGlvbiBpbXBsZW1lbnRzIElGYXJnYXRlVGFza0RlZmluaXRpb24ge1xuICAgIC8qKlxuICAgICAqIEltcG9ydHMgYSB0YXNrIGRlZmluaXRpb24gZnJvbSB0aGUgc3BlY2lmaWVkIHRhc2sgZGVmaW5pdGlvbiBBUk4uXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBmcm9tRmFyZ2F0ZVRhc2tEZWZpbml0aW9uQXJuKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGZhcmdhdGVUYXNrRGVmaW5pdGlvbkFybjogc3RyaW5nKTogSUZhcmdhdGVUYXNrRGVmaW5pdGlvbiB7XG4gICAgICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUZhcmdhdGVUYXNrRGVmaW5pdGlvbiB7XG4gICAgICAgICAgICBwdWJsaWMgcmVhZG9ubHkgdGFza0RlZmluaXRpb25Bcm4gPSBmYXJnYXRlVGFza0RlZmluaXRpb25Bcm47XG4gICAgICAgICAgICBwdWJsaWMgcmVhZG9ubHkgY29tcGF0aWJpbGl0eSA9IENvbXBhdGliaWxpdHkuRkFSR0FURTtcbiAgICAgICAgICAgIHB1YmxpYyByZWFkb25seSBpc0VjMkNvbXBhdGlibGUgPSBmYWxzZTtcbiAgICAgICAgICAgIHB1YmxpYyByZWFkb25seSBpc0ZhcmdhdGVDb21wYXRpYmxlID0gdHJ1ZTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBUaGUgRG9ja2VyIG5ldHdvcmtpbmcgbW9kZSB0byB1c2UgZm9yIHRoZSBjb250YWluZXJzIGluIHRoZSB0YXNrLiBGYXJnYXRlIHRhc2tzIHJlcXVpcmUgdGhlIGF3c3ZwYyBuZXR3b3JrIG1vZGUuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IG5ldHdvcmtNb2RlOiBOZXR3b3JrTW9kZSA9IE5ldHdvcmtNb2RlLkFXU19WUEM7XG4gICAgLy8gTk9URTogVW50aWwgdGhlIGZpeCB0byBodHRwczovL2dpdGh1Yi5jb20vTWljcm9zb2Z0L1R5cGVTY3JpcHQvaXNzdWVzLzI2OTY5IGdldHMgcmVsZWFzZWQsXG4gICAgLy8gd2UgbmVlZCB0byBleHBsaWNpdGx5IHdyaXRlIHRoZSB0eXBlIGhlcmUsIGFzIHR5cGUgZGVkdWN0aW9uIGZvciBlbnVtcyB3b24ndCBsZWFkIHRvXG4gICAgLy8gdGhlIGltcG9ydCBiZWluZyBnZW5lcmF0ZWQgaW4gdGhlIC5kLnRzIGZpbGUuXG4gICAgLyoqXG4gICAgICogQ29uc3RydWN0cyBhIG5ldyBpbnN0YW5jZSBvZiB0aGUgRmFyZ2F0ZVRhc2tEZWZpbml0aW9uIGNsYXNzLlxuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBGYXJnYXRlVGFza0RlZmluaXRpb25Qcm9wcyA9IHt9KSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgICAgICAgLi4ucHJvcHMsXG4gICAgICAgICAgICBjcHU6IHByb3BzLmNwdSAhPT0gdW5kZWZpbmVkID8gVG9rZW5pemF0aW9uLnN0cmluZ2lmeU51bWJlcihwcm9wcy5jcHUpIDogJzI1NicsXG4gICAgICAgICAgICBtZW1vcnlNaUI6IHByb3BzLm1lbW9yeUxpbWl0TWlCICE9PSB1bmRlZmluZWQgPyBUb2tlbml6YXRpb24uc3RyaW5naWZ5TnVtYmVyKHByb3BzLm1lbW9yeUxpbWl0TWlCKSA6ICc1MTInLFxuICAgICAgICAgICAgY29tcGF0aWJpbGl0eTogQ29tcGF0aWJpbGl0eS5GQVJHQVRFLFxuICAgICAgICAgICAgbmV0d29ya01vZGU6IE5ldHdvcmtNb2RlLkFXU19WUEMsXG4gICAgICAgIH0pO1xuICAgIH1cbn1cbiJdfQ==