"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderBase = exports.ProviderAttribute = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const attr_names_1 = require("../private/attr-names");
/**
 * An attribute available from a third party identity provider.
 */
class ProviderAttribute {
    constructor(attributeName) {
        this.attributeName = attributeName;
    }
    /**
     * Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     * @param attributeName the attribute value string as recognized by the provider
     */
    static other(attributeName) {
        return new ProviderAttribute(attributeName);
    }
}
exports.ProviderAttribute = ProviderAttribute;
/** The user id attribute provided by Amazon */
ProviderAttribute.AMAZON_USER_ID = new ProviderAttribute('user_id');
/** The email attribute provided by Amazon */
ProviderAttribute.AMAZON_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Amazon */
ProviderAttribute.AMAZON_NAME = new ProviderAttribute('name');
/** The postal code attribute provided by Amazon */
ProviderAttribute.AMAZON_POSTAL_CODE = new ProviderAttribute('postal_code');
/** The user id attribute provided by Facebook */
ProviderAttribute.FACEBOOK_ID = new ProviderAttribute('id');
/** The birthday attribute provided by Facebook */
ProviderAttribute.FACEBOOK_BIRTHDAY = new ProviderAttribute('birthday');
/** The email attribute provided by Facebook */
ProviderAttribute.FACEBOOK_EMAIL = new ProviderAttribute('email');
/** The name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_NAME = new ProviderAttribute('name');
/** The first name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_FIRST_NAME = new ProviderAttribute('first_name');
/** The last name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_LAST_NAME = new ProviderAttribute('last_name');
/** The middle name attribute provided by Facebook */
ProviderAttribute.FACEBOOK_MIDDLE_NAME = new ProviderAttribute('middle_name');
/** The gender attribute provided by Facebook */
ProviderAttribute.FACEBOOK_GENDER = new ProviderAttribute('gender');
/** The locale attribute provided by Facebook */
ProviderAttribute.FACEBOOK_LOCALE = new ProviderAttribute('locale');
/**
 * Options to integrate with the various social identity providers.
 */
class UserPoolIdentityProviderBase extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        props.userPool.registerIdentityProvider(this);
    }
    configureAttributeMapping() {
        if (!this.props.attributeMapping) {
            return undefined;
        }
        let mapping = {};
        mapping = Object.entries(this.props.attributeMapping)
            .filter(([k, _]) => k !== 'custom') // 'custom' handled later separately
            .reduce((agg, [k, v]) => {
            return { ...agg, [attr_names_1.StandardAttributeNames[k]]: v.attributeName };
        }, mapping);
        if (this.props.attributeMapping.custom) {
            mapping = Object.entries(this.props.attributeMapping.custom).reduce((agg, [k, v]) => {
                return { ...agg, [k]: v.attributeName };
            }, mapping);
        }
        if (Object.keys(mapping).length === 0) {
            return undefined;
        }
        return mapping;
    }
}
exports.UserPoolIdentityProviderBase = UserPoolIdentityProviderBase;
//# sourceMappingURL=data:application/json;base64,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