"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FullActionDescriptor = void 0;
/**
 * This class is private to the aws-codepipeline package.
 */
class FullActionDescriptor {
    constructor(props) {
        this.action = props.action;
        const actionProperties = props.action.actionProperties;
        this.actionName = actionProperties.actionName;
        this.category = actionProperties.category;
        this.owner = actionProperties.owner || 'AWS';
        this.provider = actionProperties.provider;
        this.version = actionProperties.version || '1';
        this.runOrder = actionProperties.runOrder === undefined ? 1 : actionProperties.runOrder;
        this.artifactBounds = actionProperties.artifactBounds;
        this.namespace = actionProperties.variablesNamespace;
        this.inputs = deduplicateArtifacts(actionProperties.inputs);
        this.outputs = deduplicateArtifacts(actionProperties.outputs);
        this.region = props.actionRegion || actionProperties.region;
        this.role = actionProperties.role !== undefined ? actionProperties.role : props.actionRole;
        this.configuration = props.actionConfig.configuration;
    }
}
exports.FullActionDescriptor = FullActionDescriptor;
function deduplicateArtifacts(artifacts) {
    const ret = new Array();
    for (const artifact of artifacts || []) {
        if (artifact.artifactName) {
            if (ret.find(a => a.artifactName === artifact.artifactName)) {
                continue;
            }
        }
        else {
            if (ret.find(a => a === artifact)) {
                continue;
            }
        }
        ret.push(artifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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