"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceCatalogDeployAction = void 0;
const codepipeline = require("../../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const action_1 = require("../action");
/**
 * CodePipeline action to connect to an existing ServiceCatalog product.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 *
 * @experimental
 */
class ServiceCatalogDeployAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            provider: 'ServiceCatalog',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.templatePath.artifact],
        });
        this.templatePath = props.templatePath.fileName;
        this.productVersionName = props.productVersionName;
        this.productVersionDescription = props.productVersionDescription;
        this.productId = props.productId;
        this.productType = 'CLOUD_FORMATION_TEMPLATE';
    }
    bound(_scope, _stage, options) {
        options.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSServiceCatalogAdminFullAccess'));
        // Attempt at least privilege; using this alone fails with "invalid template".
        // Should construct ARN: 'arn:aws:catalog:<region>:<accountID>:product/' + this.scProductId
        // options.role.addToPolicy(new PolicyStatement({
        //   resources: ['*'],
        //   actions: ['servicecatalog:UpdateProduct', 'servicecatalog:ListProvisioningArtifacts', 'servicecatalog:CreateProvisioningArtifact'],
        // }));
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                TemplateFilePath: this.templatePath,
                ProductVersionName: this.productVersionName,
                ProductVersionDescription: this.productVersionDescription,
                ProductType: this.productType,
                ProductId: this.productId,
            },
        };
    }
}
exports.ServiceCatalogDeployAction = ServiceCatalogDeployAction;
//# sourceMappingURL=data:application/json;base64,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