import * as codepipeline from "../../aws-codepipeline";
import * as sns from "../../aws-sns";
import * as cdk from "../../core";
import { Action } from './action';
/**
 * Construction properties of the {@link ManualApprovalAction}.
 */
export interface ManualApprovalActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * Optional SNS topic to send notifications to when an approval is pending.
     */
    readonly notificationTopic?: sns.ITopic;
    /**
     * A list of email addresses to subscribe to notifications when this Action is pending approval.
     * If this has been provided, but not `notificationTopic`,
     * a new Topic will be created.
     */
    readonly notifyEmails?: string[];
    /**
     * Any additional information that you want to include in the notification email message.
     */
    readonly additionalInformation?: string;
    /**
     * URL you want to provide to the reviewer as part of the approval request.
     *
     * @default - the approval request will not have an external link
     */
    readonly externalEntityLink?: string;
}
/**
 * Manual approval action.
 */
export declare class ManualApprovalAction extends Action {
    /**
     * The SNS Topic passed when constructing the Action.
     * If no Topic was passed, but `notifyEmails` were provided,
     * a new Topic will be created.
     */
    private _notificationTopic?;
    private readonly props;
    constructor(props: ManualApprovalActionProps);
    get notificationTopic(): sns.ITopic | undefined;
    protected bound(scope: cdk.Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
