"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomActionRegistration = void 0;
const codepipeline = require("../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends cdk.Construct {
    constructor(parent, id, props) {
        super(parent, id);
        new codepipeline.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: props.actionProperties === undefined ? undefined : props.actionProperties.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3VzdG9tLWFjdGlvbi1yZWdpc3RyYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjdXN0b20tYWN0aW9uLXJlZ2lzdHJhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx1REFBdUQsQ0FBQyw0REFBNEQ7QUFDcEgsa0NBQWtDLENBQUMsZ0RBQWdEO0FBd0ZuRjs7Ozs7O0dBTUc7QUFDSCxNQUFhLHdCQUF5QixTQUFRLEdBQUcsQ0FBQyxTQUFTO0lBQ3ZELFlBQVksTUFBcUIsRUFBRSxFQUFVLEVBQUUsS0FBb0M7UUFDL0UsS0FBSyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNsQixJQUFJLFlBQVksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ25ELFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixvQkFBb0IsRUFBRTtnQkFDbEIsWUFBWSxFQUFFLEtBQUssQ0FBQyxjQUFjLENBQUMsU0FBUztnQkFDNUMsWUFBWSxFQUFFLEtBQUssQ0FBQyxjQUFjLENBQUMsU0FBUzthQUMvQztZQUNELHFCQUFxQixFQUFFO2dCQUNuQixZQUFZLEVBQUUsS0FBSyxDQUFDLGNBQWMsQ0FBQyxVQUFVO2dCQUM3QyxZQUFZLEVBQUUsS0FBSyxDQUFDLGNBQWMsQ0FBQyxVQUFVO2FBQ2hEO1lBQ0QsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxJQUFJLEdBQUc7WUFDN0IsUUFBUSxFQUFFO2dCQUNOLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxTQUFTO2dCQUNsQyxvQkFBb0IsRUFBRSxLQUFLLENBQUMsWUFBWTthQUMzQztZQUNELHVCQUF1QixFQUFFLEtBQUssQ0FBQyxnQkFBZ0IsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxDQUFDLEVBQUUsRUFBRSxFQUFFO2dCQUMxRyxPQUFPO29CQUNILEdBQUcsRUFBRSxFQUFFLENBQUMsR0FBRyxJQUFJLEtBQUs7b0JBQ3BCLE1BQU0sRUFBRSxFQUFFLENBQUMsTUFBTSxJQUFJLEtBQUs7b0JBQzFCLEdBQUcsRUFBRTtpQkFDUixDQUFDO1lBQ04sQ0FBQyxDQUFDO1NBQ0wsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztDQUNKO0FBNUJELDREQTRCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVwaXBlbGluZSBmcm9tIFwiLi4vLi4vYXdzLWNvZGVwaXBlbGluZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVwaXBlbGluZSdcbmltcG9ydCAqIGFzIGNkayBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbi8qKlxuICogVGhlIGNyZWF0aW9uIGF0dHJpYnV0ZXMgdXNlZCBmb3IgZGVmaW5pbmcgYSBjb25maWd1cmF0aW9uIHByb3BlcnR5XG4gKiBvZiBhIGN1c3RvbSBBY3Rpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ3VzdG9tQWN0aW9uUHJvcGVydHkge1xuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBwcm9wZXJ0eS5cbiAgICAgKiBZb3UgdXNlIHRoaXMgbmFtZSBpbiB0aGUgYGNvbmZpZ3VyYXRpb25gIGF0dHJpYnV0ZSB3aGVuIGRlZmluaW5nIHlvdXIgY3VzdG9tIEFjdGlvbiBjbGFzcy5cbiAgICAgKi9cbiAgICBuYW1lOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIGRlc2NyaXB0aW9uIG9mIHRoZSBwcm9wZXJ0eS5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IHRoZSBkZXNjcmlwdGlvbiB3aWxsIGJlIGVtcHR5XG4gICAgICovXG4gICAgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogV2hldGhlciB0aGlzIHByb3BlcnR5IGlzIGEga2V5LlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgZmFsc2VcbiAgICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jb2RlcGlwZWxpbmUtY3VzdG9tYWN0aW9udHlwZS1jb25maWd1cmF0aW9ucHJvcGVydGllcy5odG1sI2Nmbi1jb2RlcGlwZWxpbmUtY3VzdG9tYWN0aW9udHlwZS1jb25maWd1cmF0aW9ucHJvcGVydGllcy1rZXlcbiAgICAgKi9cbiAgICBrZXk/OiBib29sZWFuO1xuICAgIC8qKlxuICAgICAqIFdoZXRoZXIgdGhpcyBwcm9wZXJ0eSBpcyBxdWVyeWFibGUuXG4gICAgICogTm90ZSB0aGF0IG9ubHkgYSBzaW5nbGUgcHJvcGVydHkgb2YgYSBjdXN0b20gQWN0aW9uIGNhbiBiZSBxdWVyeWFibGUuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWNvZGVwaXBlbGluZS1jdXN0b21hY3Rpb250eXBlLWNvbmZpZ3VyYXRpb25wcm9wZXJ0aWVzLmh0bWwjY2ZuLWNvZGVwaXBlbGluZS1jdXN0b21hY3Rpb250eXBlLWNvbmZpZ3VyYXRpb25wcm9wZXJ0aWVzLXF1ZXJ5YWJsZVxuICAgICAqL1xuICAgIHF1ZXJ5YWJsZT86IGJvb2xlYW47XG4gICAgLyoqXG4gICAgICogV2hldGhlciB0aGlzIHByb3BlcnR5IGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHJlcXVpcmVkOiBib29sZWFuO1xuICAgIC8qKlxuICAgICAqIFdoZXRoZXIgdGhpcyBwcm9wZXJ0eSBpcyBzZWNyZXQsXG4gICAgICogbGlrZSBhIHBhc3N3b3JkLCBvciBhY2Nlc3Mga2V5LlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgZmFsc2VcbiAgICAgKi9cbiAgICBzZWNyZXQ/OiBib29sZWFuO1xuICAgIC8qKlxuICAgICAqIFRoZSB0eXBlIG9mIHRoZSBwcm9wZXJ0eSxcbiAgICAgKiBsaWtlICdTdHJpbmcnLCAnTnVtYmVyJywgb3IgJ0Jvb2xlYW4nLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgJ1N0cmluZydcbiAgICAgKi9cbiAgICB0eXBlPzogc3RyaW5nO1xufVxuLyoqXG4gKiBQcm9wZXJ0aWVzIG9mIHJlZ2lzdGVyaW5nIGEgY3VzdG9tIEFjdGlvbi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDdXN0b21BY3Rpb25SZWdpc3RyYXRpb25Qcm9wcyB7XG4gICAgLyoqXG4gICAgICogVGhlIGNhdGVnb3J5IG9mIHRoZSBBY3Rpb24uXG4gICAgICovXG4gICAgY2F0ZWdvcnk6IGNvZGVwaXBlbGluZS5BY3Rpb25DYXRlZ29yeTtcbiAgICAvKipcbiAgICAgKiBUaGUgYXJ0aWZhY3QgYm91bmRzIG9mIHRoZSBBY3Rpb24uXG4gICAgICovXG4gICAgYXJ0aWZhY3RCb3VuZHM6IGNvZGVwaXBlbGluZS5BY3Rpb25BcnRpZmFjdEJvdW5kcztcbiAgICAvKipcbiAgICAgKiBUaGUgcHJvdmlkZXIgb2YgdGhlIEFjdGlvbi5cbiAgICAgKi9cbiAgICBwcm92aWRlcjogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSB2ZXJzaW9uIG9mIHlvdXIgQWN0aW9uLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgJzEnXG4gICAgICovXG4gICAgdmVyc2lvbj86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgVVJMIHNob3duIGZvciB0aGUgZW50aXJlIEFjdGlvbiBpbiB0aGUgUGlwZWxpbmUgVUkuXG4gICAgICovXG4gICAgZW50aXR5VXJsPzogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSBVUkwgc2hvd24gZm9yIGEgcGFydGljdWxhciBleGVjdXRpb24gb2YgYW4gQWN0aW9uIGluIHRoZSBQaXBlbGluZSBVSS5cbiAgICAgKi9cbiAgICBleGVjdXRpb25Vcmw/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIHByb3BlcnRpZXMgdXNlZCBmb3IgY3VzdG9taXppbmcgdGhlIGluc3RhbmNlIG9mIHlvdXIgQWN0aW9uLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgW11cbiAgICAgKi9cbiAgICBhY3Rpb25Qcm9wZXJ0aWVzPzogQ3VzdG9tQWN0aW9uUHJvcGVydHlbXTtcbn1cbi8qKlxuICogVGhlIHJlc291cmNlIHJlcHJlc2VudGluZyByZWdpc3RlcmluZyBhIGN1c3RvbSBBY3Rpb24gd2l0aCBDb2RlUGlwZWxpbmUuXG4gKiBGb3IgdGhlIEFjdGlvbiB0byBiZSB1c2FibGUsIGl0IGhhcyB0byBiZSByZWdpc3RlcmVkIGZvciBldmVyeSByZWdpb24gYW5kIGV2ZXJ5IGFjY291bnQgaXQncyB1c2VkIGluLlxuICogSW4gYWRkaXRpb24gdG8gdGhpcyBjbGFzcywgeW91IHNob3VsZCBtb3N0IGxpa2VseSBhbHNvIHByb3ZpZGUgeW91ciBjbGllbnRzIGEgY2xhc3NcbiAqIHJlcHJlc2VudGluZyB5b3VyIGN1c3RvbSBBY3Rpb24sIGV4dGVuZGluZyB0aGUgQWN0aW9uIGNsYXNzLFxuICogYW5kIHRha2luZyB0aGUgYGFjdGlvblByb3BlcnRpZXNgIGFzIHByb3Blcmx5IHR5cGVkLCBjb25zdHJ1Y3Rpb24gcHJvcGVydGllcy5cbiAqL1xuZXhwb3J0IGNsYXNzIEN1c3RvbUFjdGlvblJlZ2lzdHJhdGlvbiBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICAgIGNvbnN0cnVjdG9yKHBhcmVudDogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEN1c3RvbUFjdGlvblJlZ2lzdHJhdGlvblByb3BzKSB7XG4gICAgICAgIHN1cGVyKHBhcmVudCwgaWQpO1xuICAgICAgICBuZXcgY29kZXBpcGVsaW5lLkNmbkN1c3RvbUFjdGlvblR5cGUodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgICAgICAgY2F0ZWdvcnk6IHByb3BzLmNhdGVnb3J5LFxuICAgICAgICAgICAgaW5wdXRBcnRpZmFjdERldGFpbHM6IHtcbiAgICAgICAgICAgICAgICBtaW5pbXVtQ291bnQ6IHByb3BzLmFydGlmYWN0Qm91bmRzLm1pbklucHV0cyxcbiAgICAgICAgICAgICAgICBtYXhpbXVtQ291bnQ6IHByb3BzLmFydGlmYWN0Qm91bmRzLm1heElucHV0cyxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBvdXRwdXRBcnRpZmFjdERldGFpbHM6IHtcbiAgICAgICAgICAgICAgICBtaW5pbXVtQ291bnQ6IHByb3BzLmFydGlmYWN0Qm91bmRzLm1pbk91dHB1dHMsXG4gICAgICAgICAgICAgICAgbWF4aW11bUNvdW50OiBwcm9wcy5hcnRpZmFjdEJvdW5kcy5tYXhPdXRwdXRzLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHByb3ZpZGVyOiBwcm9wcy5wcm92aWRlcixcbiAgICAgICAgICAgIHZlcnNpb246IHByb3BzLnZlcnNpb24gfHwgJzEnLFxuICAgICAgICAgICAgc2V0dGluZ3M6IHtcbiAgICAgICAgICAgICAgICBlbnRpdHlVcmxUZW1wbGF0ZTogcHJvcHMuZW50aXR5VXJsLFxuICAgICAgICAgICAgICAgIGV4ZWN1dGlvblVybFRlbXBsYXRlOiBwcm9wcy5leGVjdXRpb25VcmwsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgY29uZmlndXJhdGlvblByb3BlcnRpZXM6IHByb3BzLmFjdGlvblByb3BlcnRpZXMgPT09IHVuZGVmaW5lZCA/IHVuZGVmaW5lZCA6IHByb3BzLmFjdGlvblByb3BlcnRpZXMubWFwKChhcCkgPT4ge1xuICAgICAgICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAgICAgICAgIGtleTogYXAua2V5IHx8IGZhbHNlLFxuICAgICAgICAgICAgICAgICAgICBzZWNyZXQ6IGFwLnNlY3JldCB8fCBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgLi4uYXAsXG4gICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIH0pLFxuICAgICAgICB9KTtcbiAgICB9XG59XG4iXX0=