import * as codepipeline from "../../aws-codepipeline";
import * as events from "../../aws-events";
import { Construct } from "../../core";
/**
 * Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
export declare abstract class Action implements codepipeline.IAction {
    readonly actionProperties: codepipeline.ActionProperties;
    private _pipeline?;
    private _stage?;
    private _scope?;
    private readonly customerProvidedNamespace?;
    private readonly namespaceOrToken;
    private actualNamespace?;
    private variableReferenced;
    protected constructor(actionProperties: codepipeline.ActionProperties);
    bind(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    protected variableExpression(variableName: string): string;
    /**
     * The method called when an Action is attached to a Pipeline.
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @param options an instance of the {@link ActionBindOptions} class,
     *   that contains the necessary information for the Action
     *   to configure itself, like a reference to the Role, etc.
     */
    protected abstract bound(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    private get pipeline();
    private get stage();
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    private get scope();
}
