"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaApplication = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const codedeploy_generated_1 = require("../codedeploy.generated");
const utils_1 = require("../utils");
/**
 * A CodeDeploy Application that deploys to an AWS Lambda function.
 *
 * @resource AWS::CodeDeploy::Application
 */
class LambdaApplication extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.applicationName,
        });
        const resource = new codedeploy_generated_1.CfnApplication(this, 'Resource', {
            applicationName: this.physicalName,
            computePlatform: 'Lambda',
        });
        this.applicationName = this.getResourceNameAttribute(resource.ref);
        this.applicationArn = this.getResourceArnAttribute(utils_1.arnForApplication(resource.ref), {
            service: 'codedeploy',
            resource: 'application',
            resourceName: this.physicalName,
            sep: ':',
        });
    }
    /**
     * Import an Application defined either outside the CDK, or in a different CDK Stack.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param lambdaApplicationName the name of the application to import
     * @returns a Construct representing a reference to an existing Application
     */
    static fromLambdaApplicationName(scope, id, lambdaApplicationName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.applicationArn = utils_1.arnForApplication(lambdaApplicationName);
                this.applicationName = lambdaApplicationName;
            }
        }
        return new Import(scope, id);
    }
}
exports.LambdaApplication = LambdaApplication;
//# sourceMappingURL=data:application/json;base64,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