"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reportGroupArnComponents = exports.renderReportGroupArn = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
// this file contains a bunch of functions shared
// between Project and ResourceGroup,
// which we don't want to make part of the public API of this module
function renderReportGroupArn(scope, reportGroupName) {
    return cdk.Stack.of(scope).formatArn(reportGroupArnComponents(reportGroupName));
}
exports.renderReportGroupArn = renderReportGroupArn;
function reportGroupArnComponents(reportGroupName) {
    return {
        service: 'codebuild',
        resource: 'report-group',
        resourceName: reportGroupName,
    };
}
exports.reportGroupArnComponents = reportGroupArnComponents;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVwb3J0LWdyb3VwLXV0aWxzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicmVwb3J0LWdyb3VwLXV0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGtDQUFrQyxDQUFDLGdEQUFnRDtBQUNuRixpREFBaUQ7QUFDakQscUNBQXFDO0FBQ3JDLG9FQUFvRTtBQUNwRSxTQUFnQixvQkFBb0IsQ0FBQyxLQUFvQixFQUFFLGVBQXVCO0lBQzlFLE9BQU8sR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsU0FBUyxDQUFDLHdCQUF3QixDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUZELG9EQUVDO0FBQ0QsU0FBZ0Isd0JBQXdCLENBQUMsZUFBdUI7SUFDNUQsT0FBTztRQUNILE9BQU8sRUFBRSxXQUFXO1FBQ3BCLFFBQVEsRUFBRSxjQUFjO1FBQ3hCLFlBQVksRUFBRSxlQUFlO0tBQ2hDLENBQUM7QUFDTixDQUFDO0FBTkQsNERBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4vLyB0aGlzIGZpbGUgY29udGFpbnMgYSBidW5jaCBvZiBmdW5jdGlvbnMgc2hhcmVkXG4vLyBiZXR3ZWVuIFByb2plY3QgYW5kIFJlc291cmNlR3JvdXAsXG4vLyB3aGljaCB3ZSBkb24ndCB3YW50IHRvIG1ha2UgcGFydCBvZiB0aGUgcHVibGljIEFQSSBvZiB0aGlzIG1vZHVsZVxuZXhwb3J0IGZ1bmN0aW9uIHJlbmRlclJlcG9ydEdyb3VwQXJuKHNjb3BlOiBjZGsuQ29uc3RydWN0LCByZXBvcnRHcm91cE5hbWU6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgcmV0dXJuIGNkay5TdGFjay5vZihzY29wZSkuZm9ybWF0QXJuKHJlcG9ydEdyb3VwQXJuQ29tcG9uZW50cyhyZXBvcnRHcm91cE5hbWUpKTtcbn1cbmV4cG9ydCBmdW5jdGlvbiByZXBvcnRHcm91cEFybkNvbXBvbmVudHMocmVwb3J0R3JvdXBOYW1lOiBzdHJpbmcpOiBjZGsuQXJuQ29tcG9uZW50cyB7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgc2VydmljZTogJ2NvZGVidWlsZCcsXG4gICAgICAgIHJlc291cmNlOiAncmVwb3J0LWdyb3VwJyxcbiAgICAgICAgcmVzb3VyY2VOYW1lOiByZXBvcnRHcm91cE5hbWUsXG4gICAgfTtcbn1cbiJdfQ==