"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystemLocation = void 0;
/**
 * FileSystemLocation provider definition for a CodeBuild Project.
 */
class FileSystemLocation {
    /**
     * EFS file system provider.
     * @param props the EFS File System location property.
     */
    static efs(props) {
        return new EfsFileSystemLocation(props);
    }
}
exports.FileSystemLocation = FileSystemLocation;
/**
 * EfsFileSystemLocation definition for a CodeBuild project.
 */
class EfsFileSystemLocation {
    constructor(props) {
        this.props = props;
    }
    bind(_scope, _project) {
        return {
            location: {
                identifier: this.props.identifier,
                location: this.props.location,
                mountOptions: this.props.mountOptions,
                mountPoint: this.props.mountPoint,
                type: 'EFS',
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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