"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Artifacts = void 0;
/**
 * Artifacts definition for a CodeBuild Project.
 */
class Artifacts {
    constructor(props) {
        this.identifier = props.identifier;
    }
    static s3(props) {
        return new S3Artifacts(props);
    }
    bind(_scope, _project) {
        return {
            artifactsProperty: {
                artifactIdentifier: this.identifier,
                type: this.type,
            },
        };
    }
}
exports.Artifacts = Artifacts;
/**
 * S3 Artifact definition for a CodeBuild Project.
 */
class S3Artifacts extends Artifacts {
    constructor(props) {
        super(props);
        this.props = props;
        this.type = 'S3';
    }
    bind(_scope, project) {
        this.props.bucket.grantReadWrite(project);
        const superConfig = super.bind(_scope, project);
        return {
            artifactsProperty: {
                ...superConfig.artifactsProperty,
                location: this.props.bucket.bucketName,
                path: this.props.path,
                namespaceType: this.props.includeBuildId === false ? 'NONE' : 'BUILD_ID',
                name: this.props.name == null ? undefined : this.props.name,
                packaging: this.props.packageZip === false ? 'NONE' : 'ZIP',
                encryptionDisabled: this.props.encryption === false ? true : undefined,
                overrideArtifactName: this.props.name == null ? true : undefined,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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