"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dashboard = exports.PeriodOverride = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cloudwatch_generated_1 = require("./cloudwatch.generated");
const layout_1 = require("./layout");
/**
 * Specify the period for graphs when the CloudWatch dashboard loads
 */
var PeriodOverride;
(function (PeriodOverride) {
    /**
     * Period of all graphs on the dashboard automatically adapt to the time range of the dashboard.
     */
    PeriodOverride["AUTO"] = "auto";
    /**
     * Period set for each graph will be used
     */
    PeriodOverride["INHERIT"] = "inherit";
})(PeriodOverride = exports.PeriodOverride || (exports.PeriodOverride = {}));
/**
 * A CloudWatch dashboard
 */
class Dashboard extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.dashboardName,
        });
        this.rows = [];
        {
            const { dashboardName } = props;
            if (dashboardName && !core_1.Token.isUnresolved(dashboardName) && !dashboardName.match(/^[\w-]+$/)) {
                throw new Error([
                    `The value ${dashboardName} for field dashboardName contains invalid characters.`,
                    'It can only contain alphanumerics, dash (-) and underscore (_).',
                ].join(' '));
            }
        }
        new cloudwatch_generated_1.CfnDashboard(this, 'Resource', {
            dashboardName: this.physicalName,
            dashboardBody: core_1.Lazy.stringValue({
                produce: () => {
                    const column = new layout_1.Column(...this.rows);
                    column.position(0, 0);
                    return core_1.Stack.of(this).toJsonString({
                        start: props.start,
                        end: props.end,
                        periodOverride: props.periodOverride,
                        widgets: column.toJson(),
                    });
                },
            }),
        });
        (props.widgets || []).forEach(row => {
            this.addWidgets(...row);
        });
    }
    /**
     * Add a widget to the dashboard.
     *
     * Widgets given in multiple calls to add() will be laid out stacked on
     * top of each other.
     *
     * Multiple widgets added in the same call to add() will be laid out next
     * to each other.
     */
    addWidgets(...widgets) {
        if (widgets.length === 0) {
            return;
        }
        const w = widgets.length > 1 ? new layout_1.Row(...widgets) : widgets[0];
        this.rows.push(w);
    }
}
exports.Dashboard = Dashboard;
//# sourceMappingURL=data:application/json;base64,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