"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsAction = void 0;
/**
 * Use an SNS topic as an alarm action
 */
class SnsAction {
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Returns an alarm action configuration to use an SNS topic as an alarm action
     */
    bind(_scope, _alarm) {
        return { alarmActionArn: this.topic.topicArn };
    }
}
exports.SnsAction = SnsAction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUdBOztHQUVHO0FBQ0gsTUFBYSxTQUFTO0lBQ2xCLFlBQTZCLEtBQWlCO1FBQWpCLFVBQUssR0FBTCxLQUFLLENBQVk7SUFDOUMsQ0FBQztJQUNEOztPQUVHO0lBQ0ksSUFBSSxDQUFDLE1BQWlCLEVBQUUsTUFBeUI7UUFDcEQsT0FBTyxFQUFFLGNBQWMsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQ25ELENBQUM7Q0FDSjtBQVRELDhCQVNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2xvdWR3YXRjaCBmcm9tIFwiLi4vLi4vYXdzLWNsb3Vkd2F0Y2hcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZHdhdGNoJ1xuaW1wb3J0ICogYXMgc25zIGZyb20gXCIuLi8uLi9hd3Mtc25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc25zJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4vKipcbiAqIFVzZSBhbiBTTlMgdG9waWMgYXMgYW4gYWxhcm0gYWN0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBTbnNBY3Rpb24gaW1wbGVtZW50cyBjbG91ZHdhdGNoLklBbGFybUFjdGlvbiB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB0b3BpYzogc25zLklUb3BpYykge1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBSZXR1cm5zIGFuIGFsYXJtIGFjdGlvbiBjb25maWd1cmF0aW9uIHRvIHVzZSBhbiBTTlMgdG9waWMgYXMgYW4gYWxhcm0gYWN0aW9uXG4gICAgICovXG4gICAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIF9hbGFybTogY2xvdWR3YXRjaC5JQWxhcm0pOiBjbG91ZHdhdGNoLkFsYXJtQWN0aW9uQ29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHsgYWxhcm1BY3Rpb25Bcm46IHRoaXMudG9waWMudG9waWNBcm4gfTtcbiAgICB9XG59XG4iXX0=