"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCertificateRegion = exports.isDnsValidatedCertificate = exports.apexDomain = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const public_suffixes_1 = require("./public-suffixes");
/**
 * Returns the apex domain (domain.com) from a subdomain (www.sub.domain.com)
 */
function apexDomain(domainName) {
    const parts = domainName.split('.').reverse();
    let curr = public_suffixes_1.publicSuffixes;
    const accumulated = [];
    for (const part of parts) {
        accumulated.push(part);
        if (!(part in curr)) {
            break;
        }
        curr = curr[part];
    }
    return accumulated.reverse().join('.');
}
exports.apexDomain = apexDomain;
function isDnsValidatedCertificate(cert) {
    return cert.hasOwnProperty('domainName');
}
exports.isDnsValidatedCertificate = isDnsValidatedCertificate;
function getCertificateRegion(cert) {
    const { certificateArn, stack } = cert;
    if (isDnsValidatedCertificate(cert)) {
        const requestResource = cert.node.findChild('CertificateRequestorResource').node.defaultChild;
        // @ts-ignore
        const { _cfnProperties: properties } = requestResource;
        const { Region: region } = properties;
        if (region && !core_1.Token.isUnresolved(region)) {
            return region;
        }
    }
    {
        const { region } = core_1.Arn.parse(certificateArn);
        if (region && !core_1.Token.isUnresolved(region)) {
            return region;
        }
    }
    return core_1.Stack.of(stack).region;
}
exports.getCertificateRegion = getCertificateRegion;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEscUNBQStDLENBQUMsZ0RBQWdEO0FBR2hHLHVEQUFtRDtBQUNuRDs7R0FFRztBQUNILFNBQWdCLFVBQVUsQ0FBQyxVQUFrQjtJQUN6QyxNQUFNLEtBQUssR0FBRyxVQUFVLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLE9BQU8sRUFBRSxDQUFDO0lBQzlDLElBQUksSUFBSSxHQUFRLGdDQUFjLENBQUM7SUFDL0IsTUFBTSxXQUFXLEdBQWEsRUFBRSxDQUFDO0lBQ2pDLEtBQUssTUFBTSxJQUFJLElBQUksS0FBSyxFQUFFO1FBQ3RCLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDdkIsSUFBSSxDQUFDLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxFQUFFO1lBQ2pCLE1BQU07U0FDVDtRQUNELElBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7S0FDckI7SUFDRCxPQUFPLFdBQVcsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7QUFDM0MsQ0FBQztBQVpELGdDQVlDO0FBQ0QsU0FBZ0IseUJBQXlCLENBQUMsSUFBa0I7SUFDeEQsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDLFlBQVksQ0FBQyxDQUFDO0FBQzdDLENBQUM7QUFGRCw4REFFQztBQUNELFNBQWdCLG9CQUFvQixDQUFDLElBQWtCO0lBQ25ELE1BQU0sRUFBRSxjQUFjLEVBQUUsS0FBSyxFQUFFLEdBQUcsSUFBSSxDQUFDO0lBQ3ZDLElBQUkseUJBQXlCLENBQUMsSUFBSSxDQUFDLEVBQUU7UUFDakMsTUFBTSxlQUFlLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsOEJBQThCLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1FBQzlGLGFBQWE7UUFDYixNQUFNLEVBQUUsY0FBYyxFQUFFLFVBQVUsRUFBRSxHQUFHLGVBQWUsQ0FBQztRQUN2RCxNQUFNLEVBQUUsTUFBTSxFQUFFLE1BQU0sRUFBRSxHQUFHLFVBQVUsQ0FBQztRQUN0QyxJQUFJLE1BQU0sSUFBSSxDQUFDLFlBQUssQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7WUFDdkMsT0FBTyxNQUFNLENBQUM7U0FDakI7S0FDSjtJQUNEO1FBQ0ksTUFBTSxFQUFFLE1BQU0sRUFBRSxHQUFHLFVBQUcsQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDN0MsSUFBSSxNQUFNLElBQUksQ0FBQyxZQUFLLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQ3ZDLE9BQU8sTUFBTSxDQUFDO1NBQ2pCO0tBQ0o7SUFDRCxPQUFPLFlBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxDQUFDO0FBQ2xDLENBQUM7QUFsQkQsb0RBa0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXJuLCBTdGFjaywgVG9rZW4gfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IElDZXJ0aWZpY2F0ZSB9IGZyb20gJy4vY2VydGlmaWNhdGUnO1xuaW1wb3J0IHsgRG5zVmFsaWRhdGVkQ2VydGlmaWNhdGUgfSBmcm9tICcuL2Rucy12YWxpZGF0ZWQtY2VydGlmaWNhdGUnO1xuaW1wb3J0IHsgcHVibGljU3VmZml4ZXMgfSBmcm9tICcuL3B1YmxpYy1zdWZmaXhlcyc7XG4vKipcbiAqIFJldHVybnMgdGhlIGFwZXggZG9tYWluIChkb21haW4uY29tKSBmcm9tIGEgc3ViZG9tYWluICh3d3cuc3ViLmRvbWFpbi5jb20pXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBhcGV4RG9tYWluKGRvbWFpbk5hbWU6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgY29uc3QgcGFydHMgPSBkb21haW5OYW1lLnNwbGl0KCcuJykucmV2ZXJzZSgpO1xuICAgIGxldCBjdXJyOiBhbnkgPSBwdWJsaWNTdWZmaXhlcztcbiAgICBjb25zdCBhY2N1bXVsYXRlZDogc3RyaW5nW10gPSBbXTtcbiAgICBmb3IgKGNvbnN0IHBhcnQgb2YgcGFydHMpIHtcbiAgICAgICAgYWNjdW11bGF0ZWQucHVzaChwYXJ0KTtcbiAgICAgICAgaWYgKCEocGFydCBpbiBjdXJyKSkge1xuICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgIH1cbiAgICAgICAgY3VyciA9IGN1cnJbcGFydF07XG4gICAgfVxuICAgIHJldHVybiBhY2N1bXVsYXRlZC5yZXZlcnNlKCkuam9pbignLicpO1xufVxuZXhwb3J0IGZ1bmN0aW9uIGlzRG5zVmFsaWRhdGVkQ2VydGlmaWNhdGUoY2VydDogSUNlcnRpZmljYXRlKTogY2VydCBpcyBEbnNWYWxpZGF0ZWRDZXJ0aWZpY2F0ZSB7XG4gICAgcmV0dXJuIGNlcnQuaGFzT3duUHJvcGVydHkoJ2RvbWFpbk5hbWUnKTtcbn1cbmV4cG9ydCBmdW5jdGlvbiBnZXRDZXJ0aWZpY2F0ZVJlZ2lvbihjZXJ0OiBJQ2VydGlmaWNhdGUpOiBzdHJpbmcgfCB1bmRlZmluZWQge1xuICAgIGNvbnN0IHsgY2VydGlmaWNhdGVBcm4sIHN0YWNrIH0gPSBjZXJ0O1xuICAgIGlmIChpc0Ruc1ZhbGlkYXRlZENlcnRpZmljYXRlKGNlcnQpKSB7XG4gICAgICAgIGNvbnN0IHJlcXVlc3RSZXNvdXJjZSA9IGNlcnQubm9kZS5maW5kQ2hpbGQoJ0NlcnRpZmljYXRlUmVxdWVzdG9yUmVzb3VyY2UnKS5ub2RlLmRlZmF1bHRDaGlsZDtcbiAgICAgICAgLy8gQHRzLWlnbm9yZVxuICAgICAgICBjb25zdCB7IF9jZm5Qcm9wZXJ0aWVzOiBwcm9wZXJ0aWVzIH0gPSByZXF1ZXN0UmVzb3VyY2U7XG4gICAgICAgIGNvbnN0IHsgUmVnaW9uOiByZWdpb24gfSA9IHByb3BlcnRpZXM7XG4gICAgICAgIGlmIChyZWdpb24gJiYgIVRva2VuLmlzVW5yZXNvbHZlZChyZWdpb24pKSB7XG4gICAgICAgICAgICByZXR1cm4gcmVnaW9uO1xuICAgICAgICB9XG4gICAgfVxuICAgIHtcbiAgICAgICAgY29uc3QgeyByZWdpb24gfSA9IEFybi5wYXJzZShjZXJ0aWZpY2F0ZUFybik7XG4gICAgICAgIGlmIChyZWdpb24gJiYgIVRva2VuLmlzVW5yZXNvbHZlZChyZWdpb24pKSB7XG4gICAgICAgICAgICByZXR1cm4gcmVnaW9uO1xuICAgICAgICB9XG4gICAgfVxuICAgIHJldHVybiBTdGFjay5vZihzdGFjaykucmVnaW9uO1xufVxuIl19