"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueHook = void 0;
/**
 * Use an SQS queue as a hook target
 */
class QueueHook {
    constructor(queue) {
        this.queue = queue;
    }
    bind(_scope, lifecycleHook) {
        this.queue.grantSendMessages(lifecycleHook.role);
        return { notificationTargetArn: this.queue.queueArn };
    }
}
exports.QueueHook = QueueHook;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicXVldWUtaG9vay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInF1ZXVlLWhvb2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLFNBQVM7SUFDbEIsWUFBNkIsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTtJQUM5QyxDQUFDO0lBQ00sSUFBSSxDQUFDLE1BQWlCLEVBQUUsYUFBeUM7UUFDcEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDakQsT0FBTyxFQUFFLHFCQUFxQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUM7SUFDMUQsQ0FBQztDQUNKO0FBUEQsOEJBT0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhdXRvc2NhbGluZyBmcm9tIFwiLi4vLi4vYXdzLWF1dG9zY2FsaW5nXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtYXV0b3NjYWxpbmcnXG5pbXBvcnQgKiBhcyBzcXMgZnJvbSBcIi4uLy4uL2F3cy1zcXNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1zcXMnXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbi8qKlxuICogVXNlIGFuIFNRUyBxdWV1ZSBhcyBhIGhvb2sgdGFyZ2V0XG4gKi9cbmV4cG9ydCBjbGFzcyBRdWV1ZUhvb2sgaW1wbGVtZW50cyBhdXRvc2NhbGluZy5JTGlmZWN5Y2xlSG9va1RhcmdldCB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBxdWV1ZTogc3FzLklRdWV1ZSkge1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgbGlmZWN5Y2xlSG9vazogYXV0b3NjYWxpbmcuSUxpZmVjeWNsZUhvb2spOiBhdXRvc2NhbGluZy5MaWZlY3ljbGVIb29rVGFyZ2V0Q29uZmlnIHtcbiAgICAgICAgdGhpcy5xdWV1ZS5ncmFudFNlbmRNZXNzYWdlcyhsaWZlY3ljbGVIb29rLnJvbGUpO1xuICAgICAgICByZXR1cm4geyBub3RpZmljYXRpb25UYXJnZXRBcm46IHRoaXMucXVldWUucXVldWVBcm4gfTtcbiAgICB9XG59XG4iXX0=