"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestValidator = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
class RequestValidator extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.requestValidatorName,
        });
        const validatorProps = {
            name: this.physicalName,
            restApiId: props.restApi.restApiId,
            validateRequestBody: props.validateRequestBody,
            validateRequestParameters: props.validateRequestParameters,
        };
        const resource = new apigateway_generated_1.CfnRequestValidator(this, 'Resource', validatorProps);
        this.requestValidatorId = resource.ref;
        const deployment = (props.restApi instanceof restapi_1.RestApi) ? props.restApi.latestDeployment : undefined;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ validator: validatorProps });
        }
    }
    static fromRequestValidatorId(scope, id, requestValidatorId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.requestValidatorId = requestValidatorId;
            }
        }
        return new Import(scope, id);
    }
}
exports.RequestValidator = RequestValidator;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVxdWVzdHZhbGlkYXRvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInJlcXVlc3R2YWxpZGF0b3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEscUNBQTRELENBQUMsZ0RBQWdEO0FBQzdHLGlFQUF1RjtBQUN2Rix1Q0FBOEM7QUF5QzlDLE1BQWEsZ0JBQWlCLFNBQVEsZUFBUTtJQWExQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2IsWUFBWSxFQUFFLEtBQUssQ0FBQyxvQkFBb0I7U0FDM0MsQ0FBQyxDQUFDO1FBQ0gsTUFBTSxjQUFjLEdBQTZCO1lBQzdDLElBQUksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUN2QixTQUFTLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxTQUFTO1lBQ2xDLG1CQUFtQixFQUFFLEtBQUssQ0FBQyxtQkFBbUI7WUFDOUMseUJBQXlCLEVBQUUsS0FBSyxDQUFDLHlCQUF5QjtTQUM3RCxDQUFDO1FBQ0YsTUFBTSxRQUFRLEdBQUcsSUFBSSwwQ0FBbUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFLGNBQWMsQ0FBQyxDQUFDO1FBQzNFLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDO1FBQ3ZDLE1BQU0sVUFBVSxHQUFHLENBQUMsS0FBSyxDQUFDLE9BQU8sWUFBWSxpQkFBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztRQUNuRyxJQUFJLFVBQVUsRUFBRTtZQUNaLFVBQVUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ3hDLFVBQVUsQ0FBQyxjQUFjLENBQUMsRUFBRSxTQUFTLEVBQUUsY0FBYyxFQUFFLENBQUMsQ0FBQztTQUM1RDtJQUNMLENBQUM7SUE3Qk0sTUFBTSxDQUFDLHNCQUFzQixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLGtCQUEwQjtRQUN6RixNQUFNLE1BQU8sU0FBUSxlQUFRO1lBQTdCOztnQkFDb0IsdUJBQWtCLEdBQUcsa0JBQWtCLENBQUM7WUFDNUQsQ0FBQztTQUFBO1FBQ0QsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFDakMsQ0FBQztDQXlCSjtBQS9CRCw0Q0ErQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb25zdHJ1Y3QsIElSZXNvdXJjZSwgUmVzb3VyY2UgfSBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbmltcG9ydCB7IENmblJlcXVlc3RWYWxpZGF0b3IsIENmblJlcXVlc3RWYWxpZGF0b3JQcm9wcyB9IGZyb20gJy4vYXBpZ2F0ZXdheS5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSVJlc3RBcGksIFJlc3RBcGkgfSBmcm9tICcuL3Jlc3RhcGknO1xuZXhwb3J0IGludGVyZmFjZSBJUmVxdWVzdFZhbGlkYXRvciBleHRlbmRzIElSZXNvdXJjZSB7XG4gICAgLyoqXG4gICAgICogSUQgb2YgdGhlIHJlcXVlc3QgdmFsaWRhdG9yLCBzdWNoIGFzIGFiYzEyM1xuICAgICAqXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlcXVlc3RWYWxpZGF0b3JJZDogc3RyaW5nO1xufVxuZXhwb3J0IGludGVyZmFjZSBSZXF1ZXN0VmFsaWRhdG9yT3B0aW9ucyB7XG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhpcyByZXF1ZXN0IHZhbGlkYXRvci5cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IE5vbmVcbiAgICAgKi9cbiAgICByZWFkb25seSByZXF1ZXN0VmFsaWRhdG9yTmFtZT86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBJbmRpY2F0ZXMgd2hldGhlciB0byB2YWxpZGF0ZSB0aGUgcmVxdWVzdCBib2R5IGFjY29yZGluZyB0b1xuICAgICAqIHRoZSBjb25maWd1cmVkIHNjaGVtYSBmb3IgdGhlIHRhcmdldGVkIEFQSSBhbmQgbWV0aG9kLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgZmFsc2VcbiAgICAgKi9cbiAgICByZWFkb25seSB2YWxpZGF0ZVJlcXVlc3RCb2R5PzogYm9vbGVhbjtcbiAgICAvKipcbiAgICAgKiBJbmRpY2F0ZXMgd2hldGhlciB0byB2YWxpZGF0ZSByZXF1ZXN0IHBhcmFtZXRlcnMuXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZhbGlkYXRlUmVxdWVzdFBhcmFtZXRlcnM/OiBib29sZWFuO1xufVxuZXhwb3J0IGludGVyZmFjZSBSZXF1ZXN0VmFsaWRhdG9yUHJvcHMgZXh0ZW5kcyBSZXF1ZXN0VmFsaWRhdG9yT3B0aW9ucyB7XG4gICAgLyoqXG4gICAgICogVGhlIHJlc3QgQVBJIHRoYXQgdGhpcyBtb2RlbCBpcyBwYXJ0IG9mLlxuICAgICAqXG4gICAgICogVGhlIHJlYXNvbiB3ZSBuZWVkIHRoZSBSZXN0QXBpIG9iamVjdCBpdHNlbGYgYW5kIG5vdCBqdXN0IHRoZSBJRCBpcyBiZWNhdXNlIHRoZSBtb2RlbFxuICAgICAqIGlzIGJlaW5nIHRyYWNrZWQgYnkgdGhlIHRvcC1sZXZlbCBSZXN0QXBpIG9iamVjdCBmb3IgdGhlIHB1cnBvc2Ugb2YgY2FsY3VsYXRpbmcgaXQnc1xuICAgICAqIGhhc2ggdG8gZGV0ZXJtaW5lIHRoZSBJRCBvZiB0aGUgZGVwbG95bWVudC4gVGhpcyBhbGxvd3MgdXMgdG8gYXV0b21hdGljYWxseSB1cGRhdGVcbiAgICAgKiB0aGUgZGVwbG95bWVudCB3aGVuIHRoZSBtb2RlbCBvZiB0aGUgUkVTVCBBUEkgY2hhbmdlcy5cbiAgICAgKi9cbiAgICByZWFkb25seSByZXN0QXBpOiBJUmVzdEFwaTtcbn1cbmV4cG9ydCBjbGFzcyBSZXF1ZXN0VmFsaWRhdG9yIGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJUmVxdWVzdFZhbGlkYXRvciB7XG4gICAgcHVibGljIHN0YXRpYyBmcm9tUmVxdWVzdFZhbGlkYXRvcklkKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlcXVlc3RWYWxpZGF0b3JJZDogc3RyaW5nKTogSVJlcXVlc3RWYWxpZGF0b3Ige1xuICAgICAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElSZXF1ZXN0VmFsaWRhdG9yIHtcbiAgICAgICAgICAgIHB1YmxpYyByZWFkb25seSByZXF1ZXN0VmFsaWRhdG9ySWQgPSByZXF1ZXN0VmFsaWRhdG9ySWQ7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgICB9XG4gICAgLyoqXG4gICAgICogSUQgb2YgdGhlIHJlcXVlc3QgdmFsaWRhdG9yLCBzdWNoIGFzIGFiYzEyM1xuICAgICAqXG4gICAgICogQGF0dHJpYnV0ZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSByZXF1ZXN0VmFsaWRhdG9ySWQ6IHN0cmluZztcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUmVxdWVzdFZhbGlkYXRvclByb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgICAgICAgcGh5c2ljYWxOYW1lOiBwcm9wcy5yZXF1ZXN0VmFsaWRhdG9yTmFtZSxcbiAgICAgICAgfSk7XG4gICAgICAgIGNvbnN0IHZhbGlkYXRvclByb3BzOiBDZm5SZXF1ZXN0VmFsaWRhdG9yUHJvcHMgPSB7XG4gICAgICAgICAgICBuYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICAgICAgICAgIHJlc3RBcGlJZDogcHJvcHMucmVzdEFwaS5yZXN0QXBpSWQsXG4gICAgICAgICAgICB2YWxpZGF0ZVJlcXVlc3RCb2R5OiBwcm9wcy52YWxpZGF0ZVJlcXVlc3RCb2R5LFxuICAgICAgICAgICAgdmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVyczogcHJvcHMudmFsaWRhdGVSZXF1ZXN0UGFyYW1ldGVycyxcbiAgICAgICAgfTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuUmVxdWVzdFZhbGlkYXRvcih0aGlzLCAnUmVzb3VyY2UnLCB2YWxpZGF0b3JQcm9wcyk7XG4gICAgICAgIHRoaXMucmVxdWVzdFZhbGlkYXRvcklkID0gcmVzb3VyY2UucmVmO1xuICAgICAgICBjb25zdCBkZXBsb3ltZW50ID0gKHByb3BzLnJlc3RBcGkgaW5zdGFuY2VvZiBSZXN0QXBpKSA/IHByb3BzLnJlc3RBcGkubGF0ZXN0RGVwbG95bWVudCA6IHVuZGVmaW5lZDtcbiAgICAgICAgaWYgKGRlcGxveW1lbnQpIHtcbiAgICAgICAgICAgIGRlcGxveW1lbnQubm9kZS5hZGREZXBlbmRlbmN5KHJlc291cmNlKTtcbiAgICAgICAgICAgIGRlcGxveW1lbnQuYWRkVG9Mb2dpY2FsSWQoeyB2YWxpZGF0b3I6IHZhbGlkYXRvclByb3BzIH0pO1xuICAgICAgICB9XG4gICAgfVxufVxuIl19