"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorizer = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const method_1 = require("./method");
const AUTHORIZER_SYMBOL = Symbol.for('@aws-cdk/aws-apigateway.Authorizer');
/**
 * Base class for all custom authorizers
 */
class Authorizer extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.authorizationType = method_1.AuthorizationType.CUSTOM;
        Object.defineProperty(this, AUTHORIZER_SYMBOL, { value: true });
    }
    /**
     * Return whether the given object is an Authorizer.
     */
    static isAuthorizer(x) {
        return x !== null && typeof (x) === 'object' && AUTHORIZER_SYMBOL in x;
    }
}
exports.Authorizer = Authorizer;
//# sourceMappingURL=data:application/json;base64,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